/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env;

import com.att.inno.env.APIException;
import com.att.inno.env.Store;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class BaseDataFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema genSchema(Store env, String ... filenames) throws APIException {
        String schemaDir = env.get(env.staticSlot("env-schema_dir"), "src/main/xsd");
        File dir = new File(schemaDir);
        if (!dir.exists()) {
            throw new APIException("Schema Directory " + schemaDir + " does not exist.  You can set this with " + "env-schema_dir" + " property");
        }
        FileInputStream[] fis = new FileInputStream[filenames.length];
        Source[] sources = new Source[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            File f = new File(schemaDir + File.separatorChar + filenames[i]);
            if (!f.exists() && !f.exists()) {
                throw new APIException("Cannot find " + f.getName() + " for schema validation");
            }
            try {
                fis[i] = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new APIException(e);
            }
            sources[i] = new StreamSource(fis[i]);
        }
        try {
            String i = "http://www.w3.org/2001/XMLSchema";
            synchronized ("http://www.w3.org/2001/XMLSchema") {
                try {
                    Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
                    // ** MonitorExit[i] (shouldn't be in output)
                    return schema;
                }
                catch (Throwable throwable) {
                    try {
                        // ** MonitorExit[i] (shouldn't be in output)
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new APIException(e);
                    }
                }
            }
        }
        finally {
            for (FileInputStream d : fis) {
                try {
                    d.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static QName getQName(Class<?> clss) throws APIException {
        XmlRootElement xre = clss.getAnnotation(XmlRootElement.class);
        if (xre == null) {
            throw new APIException(clss.getName() + " does not have an XmlRootElement annotation");
        }
        Package pkg = clss.getPackage();
        XmlSchema xs = pkg.getAnnotation(XmlSchema.class);
        if (xs == null) {
            throw new APIException(clss.getName() + " package-info does not have an XmlSchema annotation");
        }
        return new QName(xs.namespace(), xre.name());
    }
}

