/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env;

import com.att.inno.env.util.Chrono;
import java.io.PrintStream;
import java.util.Date;

public interface LogTarget {
    public static final LogTarget NULL = new LogTarget(){

        @Override
        public void log(Object ... msgs) {
        }

        @Override
        public void log(Throwable t, Object ... msgs) {
        }

        @Override
        public boolean isLoggable() {
            return false;
        }

        @Override
        public void printf(String fmt, Object ... vars) {
        }
    };
    public static final LogTarget SYSOUT = new LogTarget(){

        @Override
        public void log(Object ... msgs) {
            PrintStream out = System.out;
            out.print(Chrono.dateFmt.format(new Date()));
            out.print(": ");
            for (Object str : msgs) {
                if (str != null) {
                    out.print(str.toString());
                    out.print(' ');
                    continue;
                }
                out.print("null ");
            }
            out.println();
        }

        @Override
        public void log(Throwable t, Object ... msgs) {
            PrintStream out = System.out;
            out.print(Chrono.dateFmt.format(new Date()));
            out.print(": ");
            for (Object str : msgs) {
                out.print(str.toString());
                out.print(' ');
            }
            out.println();
            t.printStackTrace(out);
            out.println();
        }

        @Override
        public boolean isLoggable() {
            return true;
        }

        @Override
        public void printf(String fmt, Object ... vars) {
            this.log(String.format(fmt, vars));
        }
    };
    public static final LogTarget SYSERR = new LogTarget(){

        @Override
        public void log(Object ... msgs) {
            PrintStream out = System.err;
            out.print(Chrono.dateFmt.format(new Date()));
            out.print(": ");
            for (Object str : msgs) {
                out.print(str.toString());
                out.print(' ');
            }
            out.println();
            out.flush();
        }

        @Override
        public void log(Throwable t, Object ... msgs) {
            PrintStream out = System.err;
            out.print(Chrono.dateFmt.format(new Date()));
            out.print(": ");
            for (Object str : msgs) {
                out.print(str.toString());
                out.print(' ');
            }
            out.println();
            t.printStackTrace(out);
        }

        @Override
        public boolean isLoggable() {
            return true;
        }

        @Override
        public void printf(String fmt, Object ... vars) {
            this.log(String.format(fmt, vars));
        }
    };

    public void log(Object ... var1);

    public void log(Throwable var1, Object ... var2);

    public boolean isLoggable();

    public void printf(String var1, Object ... var2);
}

