/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env;

import com.att.inno.env.Slot;
import com.att.inno.env.StaticSlot;
import com.att.inno.env.Store;
import com.att.inno.env.util.Split;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StoreImpl
implements Store {
    private static final int growSize = 10;
    private int local;
    private int stat;
    private HashMap<String, Slot> localMap;
    private HashMap<String, StaticSlot> staticMap;
    private Object[] staticState = new Object[10];

    public StoreImpl() {
        this.staticMap = new HashMap();
        this.localMap = new HashMap();
    }

    public StoreImpl(String tag, String[] args) {
        this.staticMap = new HashMap();
        this.localMap = new HashMap();
        if (tag != null) {
            String tequals = tag + '=';
            String[] stringArray = args;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String arg = stringArray[i];
                if (!arg.startsWith(tequals) || arg.equals(tequals)) continue;
                Properties props = new Properties();
                for (String f : Split.split(';', arg.substring(tequals.length()))) {
                    this.moreProps(new File(f), props);
                }
                for (Map.Entry entry : props.entrySet()) {
                    this.put(this.staticSlot(entry.getKey().toString()), entry.getValue());
                }
            }
        }
        for (String arg : args) {
            String[] sarg = Split.split('=', arg);
            if (sarg.length != 2) continue;
            this.put(this.staticSlot(sarg[0]), sarg[1]);
        }
    }

    public StoreImpl(String tag, Properties props) {
        String fname;
        this.staticMap = new HashMap();
        this.localMap = new HashMap();
        if (tag != null && (fname = props.getProperty(tag)) != null) {
            for (String f : Split.split(';', fname)) {
                if (this.moreProps(new File(f), props)) continue;
                System.err.println("Unable to load Properties from " + f);
            }
        }
        for (Map.Entry<Object, Object> es : props.entrySet()) {
            this.put(this.staticSlot(es.getKey().toString()), es.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moreProps(File f, Properties target) {
        if (f.exists()) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(f);
                try {
                    props.load(fis);
                    target.load(fis);
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
            for (Map.Entry<Object, Object> es : props.entrySet()) {
                this.put(this.staticSlot(es.getKey().toString()), es.getValue());
            }
            return true;
        }
        return false;
    }

    public Object[] newTransState() {
        return new Object[this.local];
    }

    @Override
    public synchronized Slot slot(String name) {
        Slot slot = this.localMap.get(name = name == null ? "" : name.trim());
        if (slot == null) {
            slot = new Slot(this.local++, name);
            this.localMap.put(name, slot);
        }
        return slot;
    }

    @Override
    public Slot existingSlot(String name) {
        return this.localMap.get(name);
    }

    @Override
    public List<String> existingSlotNames() {
        return new ArrayList<String>(this.localMap.keySet());
    }

    @Override
    public synchronized StaticSlot staticSlot(String name) {
        StaticSlot slot = this.staticMap.get(name = name == null ? "" : name.trim());
        if (slot == null) {
            if (this.stat % 10 == 0) {
                Object[] temp = this.staticState;
                this.staticState = new Object[temp.length + 10];
                System.arraycopy(temp, 0, this.staticState, 0, temp.length);
            }
            slot = new StaticSlot(this.stat++, name);
            this.staticMap.put(name, slot);
        }
        return slot;
    }

    @Override
    public void put(StaticSlot slot, Object value) {
        this.staticState[slot.slot] = value;
    }

    @Override
    public <T> T get(StaticSlot sslot, T dflt) {
        Object t = this.staticState[sslot.slot];
        return (T)(t == null ? dflt : t);
    }

    @Override
    public <T> T get(StaticSlot sslot) {
        return (T)this.staticState[sslot.slot];
    }

    @Override
    public List<String> existingStaticSlotNames() {
        return new ArrayList<String>(this.staticMap.keySet());
    }
}

