/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.impl;

import com.att.inno.env.Env;
import com.att.inno.env.LogTarget;
import com.att.inno.env.Slot;
import com.att.inno.env.StoreImpl;
import com.att.inno.env.TimeTaken;
import com.att.inno.env.Trans;
import com.att.inno.env.TransStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class AbsTrans<ENV extends Env>
implements TransStore {
    private static final float[] EMPTYF = new float[0];
    private static final Object[] EMPTYO = new Object[0];
    protected ENV delegate;
    protected List<TimeTaken> trail = new ArrayList<TimeTaken>(30);
    private Object[] state;

    public AbsTrans(ENV delegate) {
        this.delegate = delegate;
        this.state = delegate instanceof StoreImpl ? ((StoreImpl)delegate).newTransState() : EMPTYO;
    }

    @Override
    public LogTarget fatal() {
        return this.delegate.fatal();
    }

    @Override
    public LogTarget error() {
        return this.delegate.error();
    }

    @Override
    public LogTarget audit() {
        return this.delegate.audit();
    }

    @Override
    public LogTarget init() {
        return this.delegate.init();
    }

    @Override
    public LogTarget warn() {
        return this.delegate.warn();
    }

    @Override
    public LogTarget info() {
        return this.delegate.info();
    }

    @Override
    public LogTarget debug() {
        return this.delegate.debug();
    }

    @Override
    public LogTarget trace() {
        return this.delegate.trace();
    }

    protected abstract TimeTaken newTimeTaken(String var1, int var2);

    @Override
    public final TimeTaken start(String name, int flag) {
        TimeTaken tt = this.newTimeTaken(name, flag);
        this.trail.add(tt);
        return tt;
    }

    @Override
    public final void checkpoint(String name) {
        TimeTaken tt = this.newTimeTaken(name, 16);
        tt.done();
        this.trail.add(tt);
    }

    @Override
    public final void checkpoint(String name, int additionalFlag) {
        TimeTaken tt = this.newTimeTaken(name, 0x10 | additionalFlag);
        tt.done();
        this.trail.add(tt);
    }

    @Override
    public Trans.Metric auditTrail(int indent, StringBuilder sb, int ... flags) {
        Trans.Metric metric = new Trans.Metric();
        metric.entries = this.trail.size();
        int last = metric.entries - 1;
        float[] fArray = metric.buckets = flags.length == 0 ? EMPTYF : new float[flags.length];
        if (last >= 0) {
            TimeTaken first = this.trail.get(0);
            long end = this.trail.get(last).end();
            metric.total = (float)(end - first.start) / 1000000.0f;
        }
        if (sb == null) {
            for (TimeTaken tt : this.trail) {
                float ms = tt.millis();
                for (int i = 0; i < flags.length; ++i) {
                    if (tt.flag != flags[i]) continue;
                    int n = i;
                    metric.buckets[n] = metric.buckets[n] + ms;
                }
            }
        } else if (!this.info().isLoggable()) {
            boolean first = true;
            for (TimeTaken tt : this.trail) {
                float ms = tt.millis();
                for (int i = 0; i < flags.length; ++i) {
                    if (tt.flag != flags[i]) continue;
                    int n = i;
                    metric.buckets[n] = metric.buckets[n] + ms;
                }
                if ((tt.flag & 0x20) != 32) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append('/');
                }
                sb.append(tt.name);
            }
        } else {
            Stack<Long> stack = new Stack<Long>();
            for (TimeTaken tt : this.trail) {
                while (!stack.isEmpty() && tt.end() > (Long)stack.peek()) {
                    --indent;
                    stack.pop();
                }
                for (int i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
                tt.output(sb);
                sb.append('\n');
                if ((tt.flag & 8) == 8) {
                    stack.push(tt.end());
                    ++indent;
                }
                float ms = tt.millis();
                for (int i = 0; i < flags.length; ++i) {
                    if (tt.flag != flags[i]) continue;
                    int n = i;
                    metric.buckets[n] = metric.buckets[n] + ms;
                }
            }
        }
        return metric;
    }

    @Override
    public void put(Slot slot, Object value) {
        slot.put(this.state, value);
    }

    @Override
    public <T> T get(Slot slot, T deflt) {
        Object o;
        try {
            o = slot.get(this.state);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] temp = ((StoreImpl)this.delegate).newTransState();
            System.arraycopy(this.state, 0, temp, 0, this.state.length);
            this.state = temp;
            o = null;
        }
        return (T)(o == null ? deflt : o);
    }
}

