/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.impl;

import com.att.inno.env.APIException;
import com.att.inno.env.DataFactory;
import com.att.inno.env.Decryptor;
import com.att.inno.env.Encryptor;
import com.att.inno.env.EnvJAXB;
import com.att.inno.env.LogTarget;
import com.att.inno.env.StoreImpl;
import com.att.inno.env.TimeTaken;
import com.att.inno.env.TransCreate;
import com.att.inno.env.TransJAXB;
import com.att.inno.env.impl.BasicTrans;
import com.att.inno.env.jaxb.JAXBDF;
import com.att.inno.env.util.Split;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;

public class BasicEnv
extends StoreImpl
implements EnvJAXB,
TransCreate<TransJAXB> {
    protected LogTarget fatal = LogTarget.SYSERR;
    protected LogTarget error = LogTarget.SYSERR;
    protected LogTarget audit = LogTarget.SYSOUT;
    protected LogTarget init = LogTarget.SYSOUT;
    protected LogTarget warn = LogTarget.SYSERR;
    protected LogTarget info = LogTarget.SYSOUT;
    protected LogTarget debug = LogTarget.NULL;
    protected LogTarget trace = LogTarget.NULL;
    protected Decryptor decryptor = Decryptor.NULL;
    protected Encryptor encryptor = Encryptor.NULL;

    public BasicEnv(String ... args) {
        super(null, args);
    }

    public BasicEnv(String tag, String[] args) {
        super(tag, args);
    }

    public BasicEnv(Applet applet, String ... tags) {
        super(null, tags);
    }

    public BasicEnv(Properties props) {
        super(null, props);
    }

    public BasicEnv(String tag, Properties props) {
        super(tag, props);
    }

    @Override
    public LogTarget fatal() {
        return this.fatal;
    }

    @Override
    public LogTarget error() {
        return this.error;
    }

    @Override
    public LogTarget audit() {
        return this.audit;
    }

    @Override
    public LogTarget init() {
        return this.init;
    }

    @Override
    public LogTarget warn() {
        return this.warn;
    }

    @Override
    public LogTarget info() {
        return this.info;
    }

    @Override
    public LogTarget debug() {
        return this.debug;
    }

    public void debug(LogTarget lt) {
        this.debug = lt;
    }

    @Override
    public LogTarget trace() {
        return this.trace;
    }

    @Override
    public TimeTaken start(String name, int flag) {
        return new TimeTaken(name, flag){

            @Override
            public void output(StringBuilder sb) {
                switch (this.flag) {
                    case 2: {
                        sb.append("XML ");
                        break;
                    }
                    case 4: {
                        sb.append("JSON ");
                        break;
                    }
                    case 1: {
                        sb.append("REMOTE ");
                    }
                }
                sb.append(this.name);
                if (this.flag != 16) {
                    sb.append(' ');
                    sb.append((float)(this.end - this.start) / 1000000.0f);
                    sb.append("ms");
                    if (this.size >= 0L) {
                        sb.append(" size: ");
                        sb.append(Long.toString(this.size));
                    }
                }
            }
        };
    }

    @Override
    public String getProperty(String key) {
        return this.get(this.staticSlot(key), null);
    }

    public Properties getProperties(String ... filter) {
        Properties props = new Properties();
        for (String key : this.existingStaticSlotNames()) {
            boolean yes;
            if (filter.length > 0) {
                yes = false;
                for (String f : filter) {
                    if (!key.startsWith(f)) continue;
                    yes = true;
                    break;
                }
            } else {
                yes = true;
            }
            if (!yes) continue;
            props.put(key, this.getProperty(key));
        }
        return props;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.get(this.staticSlot(key), defaultValue);
    }

    @Override
    public String setProperty(String key, String value) {
        this.put(this.staticSlot(key), value);
        return value;
    }

    @Override
    public Decryptor decryptor() {
        return this.decryptor;
    }

    public void set(Decryptor newDecryptor) {
        this.decryptor = newDecryptor;
    }

    @Override
    public Encryptor encryptor() {
        return this.encryptor;
    }

    public void set(Encryptor newEncryptor) {
        this.encryptor = newEncryptor;
    }

    @Override
    public <T> DataFactory<T> newDataFactory(Class<?> ... classes) throws APIException {
        return new JAXBDF((EnvJAXB)this, classes);
    }

    @Override
    public <T> DataFactory<T> newDataFactory(Schema schema, Class<?> ... classes) throws APIException {
        return new JAXBDF((EnvJAXB)this, schema, classes);
    }

    @Override
    public <T> DataFactory<T> newDataFactory(QName qName, Class<?> ... classes) throws APIException {
        return new JAXBDF((EnvJAXB)this, qName, classes);
    }

    @Override
    public <T> DataFactory<T> newDataFactory(Schema schema, QName qName, Class<?> ... classes) throws APIException {
        return new JAXBDF((EnvJAXB)this, schema, qName, classes);
    }

    @Override
    public BasicTrans newTrans() {
        return new BasicTrans(this);
    }

    public void loadFromSystemPropsStartsWith(String ... str) {
        for (String name : System.getProperties().stringPropertyNames()) {
            for (String s : str) {
                if (!name.startsWith(s)) continue;
                this.setProperty(name, System.getProperty(name));
            }
        }
    }

    public void loadToSystemPropsStartsWith(String ... str) {
        for (String name : this.existingStaticSlotNames()) {
            for (String s : str) {
                String value;
                if (!name.startsWith(s) || (value = this.getProperty(name)) == null) continue;
                System.setProperty(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropFiles(String tag, ClassLoader classloader) throws IOException {
        String propfiles = this.getProperty(tag);
        if (propfiles != null) {
            for (String pf : Split.splitTrim(';', propfiles)) {
                File f;
                InputStream is;
                InputStream inputStream = is = classloader == null ? null : classloader.getResourceAsStream(pf);
                if (is == null && (f = new File(pf)).exists()) {
                    is = new FileInputStream(f);
                }
                if (is == null) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        String[] tv;
                        if ((line = line.trim()).startsWith("#") || (tv = Split.splitTrim('=', line)).length != 2) continue;
                        this.setProperty(tv[0], tv[1]);
                    }
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        this.error().log(e, new Object[0]);
                    }
                }
            }
        }
    }
}

