/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.impl;

import com.att.inno.env.LogTarget;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLogTarget
implements LogTarget {
    private Level level;
    private Logger log;

    public JavaUtilLogTarget(Logger logger, Level theLevel) {
        this.log = logger;
        this.level = theLevel;
    }

    @Override
    public boolean isLoggable() {
        return this.log.isLoggable(this.level);
    }

    @Override
    public void log(Object ... msgs) {
        if (this.log.isLoggable(this.level)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < msgs.length; ++i) {
                char last;
                String msg = msgs[i].toString();
                if (msg == null || msg.length() <= 0) continue;
                int sbl = sb.length();
                if (sbl > 0 && " (.".indexOf(last = sb.charAt(sbl - 1)) < 0 && "().".indexOf(msg.charAt(0)) < 0) {
                    sb.append(' ');
                }
                sb.append(msg);
            }
            this.log.log(this.level, sb.toString());
        }
    }

    @Override
    public void log(Throwable e, Object ... msgs) {
        String str = e.getLocalizedMessage();
        if (str == null) {
            str = e.getMessage();
        }
        if (str == null) {
            str = e.getClass().getName();
        }
        this.log.log(this.level, str, msgs);
    }

    @Override
    public void printf(String fmt, Object ... vars) {
        if (this.log.isLoggable(this.level)) {
            this.log.log(this.level, String.format(fmt, vars));
        }
    }
}

