/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.impl;

import com.att.inno.env.APIException;
import com.att.inno.env.LogTarget;
import com.att.inno.env.impl.BasicEnv;
import com.att.inno.env.util.StringBuilderWriter;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLogTarget
implements LogTarget {
    private Level level;
    private Logger log;

    public Log4JLogTarget(String loggerName, Level level) throws APIException {
        this.level = level;
        this.log = loggerName != null && loggerName.length() > 0 ? Logger.getLogger((String)loggerName) : Logger.getRootLogger();
    }

    @Override
    public boolean isLoggable() {
        return this.log.isEnabledFor((Priority)this.level);
    }

    @Override
    public void log(Object ... msgs) {
        this.log(null, msgs);
    }

    @Override
    public void log(Throwable e, Object ... msgs) {
        if (this.log.isEnabledFor((Priority)this.level)) {
            StringBuilder sb = new StringBuilder();
            if (e != null) {
                e.printStackTrace(new PrintWriter(new StringBuilderWriter(sb)));
            }
            for (int i = 0; i < msgs.length; ++i) {
                char last;
                String msg;
                if (msgs[i] == null || (msg = msgs[i].toString()) == null || msg.length() <= 0) continue;
                int sbl = sb.length();
                if (sbl > 0 && " (.".indexOf(last = sb.charAt(sbl - 1)) < 0 && "().".indexOf(msg.charAt(0)) < 0) {
                    sb.append(' ');
                }
                sb.append(msg);
            }
            this.log.log((Priority)this.level, (Object)sb.toString());
        }
    }

    @Override
    public void printf(String fmt, Object ... vars) {
        if (this.log.isEnabledFor((Priority)this.level)) {
            this.log.log((Priority)this.level, (Object)String.format(fmt, vars));
        }
    }

    public static void setLog4JEnv(String loggerName, BasicEnv env) throws APIException {
        env.fatal = new Log4JLogTarget(loggerName, Level.FATAL);
        env.error = new Log4JLogTarget(loggerName, Level.ERROR);
        env.audit = env.init = new Log4JLogTarget(loggerName, Level.WARN);
        env.warn = env.init;
        env.info = new Log4JLogTarget(loggerName, Level.INFO);
        env.debug = new Log4JLogTarget(loggerName, Level.DEBUG);
        env.trace = new Log4JLogTarget(loggerName, Level.TRACE);
    }
}

