/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.jaxb;

import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.inno.env.Env;
import com.att.inno.env.EnvJAXB;
import com.att.inno.env.jaxb.JAXBDF;
import com.att.inno.env.old.IOStringifier;
import com.att.inno.env.old.Objectifier;
import com.att.inno.env.old.Stringifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBException;

public final class JAXBData<T>
implements Data<T> {
    private Stringifier<T> stringifier;
    private Objectifier<T> objectifier;
    private String dataAsString;
    private T dataAsObject;
    private Class<T> tclass;
    private JAXBDF<T> df;
    private Env creatingEnv;
    private boolean[] options = new boolean[]{false, false};

    JAXBData(Env env, JAXBDF<T> df, Stringifier<T> strfr, Objectifier<T> objfr, String text, Class<T> typeClass) {
        this.dataAsString = text;
        this.dataAsObject = null;
        this.stringifier = strfr;
        this.objectifier = objfr;
        this.tclass = typeClass;
        this.creatingEnv = env;
        this.df = df;
    }

    JAXBData(Env env, JAXBDF<T> df, Stringifier<T> strfr, Objectifier<T> objfr, T object) {
        this.dataAsString = null;
        this.dataAsObject = object;
        this.stringifier = strfr;
        this.objectifier = objfr;
        this.tclass = object.getClass();
        this.creatingEnv = env;
        this.df = df;
    }

    public String asString(EnvJAXB env) throws APIException {
        if (this.dataAsString != null) {
            return this.dataAsString;
        }
        this.dataAsString = this.stringifier.stringify(env, this.dataAsObject, new boolean[0]);
        return this.dataAsString;
    }

    @Override
    public String asString() throws APIException {
        if (this.dataAsString != null) {
            return this.dataAsString;
        }
        this.dataAsString = this.stringifier.stringify(this.creatingEnv, this.dataAsObject, this.options);
        return this.dataAsString;
    }

    @Override
    public Data<T> to(OutputStream os) throws APIException, IOException {
        if (this.dataAsString != null) {
            os.write(this.dataAsString.getBytes());
        } else if (this.stringifier instanceof IOStringifier) {
            ((IOStringifier)this.stringifier).stringify(this.creatingEnv, this.dataAsObject, os, this.options);
        } else {
            this.dataAsString = this.stringifier.stringify(this.creatingEnv, this.dataAsObject, this.options);
            os.write(this.dataAsString.getBytes());
        }
        return this;
    }

    @Override
    public JAXBData<T> to(Writer writer) throws APIException, IOException {
        if (this.dataAsString != null) {
            writer.write(this.dataAsString);
        } else if (this.stringifier instanceof IOStringifier) {
            ((IOStringifier)this.stringifier).stringify(this.creatingEnv, this.dataAsObject, writer, this.options);
        } else {
            this.dataAsString = this.stringifier.stringify(this.creatingEnv, this.dataAsObject, this.options);
            writer.write(this.dataAsString);
        }
        return this;
    }

    public InputStream getInputStream() throws APIException {
        if (this.dataAsString == null) {
            this.dataAsString = this.stringifier.stringify(this.creatingEnv, this.dataAsObject, this.options);
        }
        return new ByteArrayInputStream(this.dataAsString.getBytes());
    }

    public T asObject(EnvJAXB env) throws APIException {
        if (this.dataAsObject != null) {
            return this.dataAsObject;
        }
        this.dataAsObject = this.objectifier.objectify(env, this.dataAsString);
        return this.dataAsObject;
    }

    @Override
    public T asObject() throws APIException {
        if (this.dataAsObject != null) {
            return this.dataAsObject;
        }
        this.dataAsObject = this.objectifier.objectify(this.creatingEnv, this.dataAsString);
        return this.dataAsObject;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.tclass;
    }

    public String toString() {
        if (this.dataAsString != null) {
            return this.dataAsString;
        }
        try {
            this.dataAsString = this.stringifier.stringify(this.creatingEnv, this.dataAsObject, new boolean[0]);
            return this.dataAsString;
        }
        catch (APIException e) {
            return "ERROR - Can't Stringify from Object " + e.getLocalizedMessage();
        }
    }

    @Override
    public Data<T> load(T t) throws APIException {
        this.dataAsObject = t;
        this.dataAsString = null;
        return this;
    }

    @Override
    public Data<T> load(String str) throws APIException {
        this.dataAsObject = null;
        this.dataAsString = str;
        return this;
    }

    @Override
    public Data<T> load(InputStream is) throws APIException {
        try {
            this.dataAsObject = this.df.jumar.unmarshal(this.creatingEnv.debug(), is);
            this.dataAsString = null;
        }
        catch (JAXBException e) {
            throw new APIException(e);
        }
        return this;
    }

    @Override
    public Data<T> load(Reader rdr) throws APIException {
        try {
            this.dataAsObject = this.df.jumar.unmarshal(this.creatingEnv.debug(), rdr);
            this.dataAsString = null;
        }
        catch (JAXBException e) {
            throw new APIException(e);
        }
        return this;
    }

    @Override
    public void direct(InputStream input, OutputStream output) throws APIException, IOException {
        int count;
        byte[] b = new byte[128];
        do {
            if ((count = input.read(b)) <= 0) continue;
            output.write(b, 0, count);
        } while (count >= 0);
    }

    @Override
    public Data<T> out(Data.TYPE type) {
        return this;
    }

    @Override
    public Data<T> in(Data.TYPE type) {
        return this;
    }

    @Override
    public Data<T> option(int option) {
        this.options[0] = (option & 0x100000) == 0x100000;
        this.options[1] = (option & 0x200000) == 0x200000;
        return this;
    }
}

