/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Chrono {
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    public static final DateFormat dateFmt;
    public static final DateFormat dateOnlyFmt;
    public static final DateFormat niceDateFmt;
    public static final DateFormat utcFmt;
    public static final DatatypeFactory xmlDatatypeFactory;
    public static final String BAD_DIR_CHARS_REGEX = "[/:\\;.]";
    public static final String SPLIT_DIR_REGEX = "/";
    private static long sequence;

    public static XMLGregorianCalendar timeStamp() {
        return xmlDatatypeFactory.newXMLGregorianCalendar(new GregorianCalendar());
    }

    public static XMLGregorianCalendar timeStamp(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return xmlDatatypeFactory.newXMLGregorianCalendar(gc);
    }

    public static XMLGregorianCalendar timeStamp(GregorianCalendar gc) {
        return xmlDatatypeFactory.newXMLGregorianCalendar(gc);
    }

    public static String utcStamp() {
        return utcFmt.format(new Date());
    }

    public static String utcStamp(Date date) {
        if (date == null) {
            return "";
        }
        return utcFmt.format(date);
    }

    public static String utcStamp(GregorianCalendar gc) {
        if (gc == null) {
            return "";
        }
        return utcFmt.format(gc.getTime());
    }

    public static String utcStamp(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return "";
        }
        return utcFmt.format(xgc.toGregorianCalendar().getTime());
    }

    public static String dateStamp() {
        return dateFmt.format(new Date());
    }

    public static String dateStamp(GregorianCalendar gc) {
        if (gc == null) {
            return "";
        }
        return dateFmt.format(gc.getTime());
    }

    public static String dateStamp(Date date) {
        if (date == null) {
            return "";
        }
        return dateFmt.format(date);
    }

    public static String dateStamp(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return "";
        }
        return dateFmt.format(xgc.toGregorianCalendar().getTime());
    }

    public static String dateTime() {
        return Chrono.dateTime(new GregorianCalendar());
    }

    public static String dateTime(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return Chrono.dateTime(gc);
    }

    public static String dateTime(GregorianCalendar gc) {
        if (gc == null) {
            return "";
        }
        TimeZone tz = gc.getTimeZone();
        int tz1 = (tz.getRawOffset() + tz.getDSTSavings()) / 36000;
        int tz1abs = Math.abs(tz1);
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(10), gc.get(12), gc.get(13), gc.get(14), Character.valueOf(tz1 == tz1abs ? (char)'+' : '-'), tz1abs / 100, (tz1abs - tz1abs / 100 * 100) * 6 / 10);
    }

    public static String dateTime(XMLGregorianCalendar xgc) {
        return xgc == null ? "" : Chrono.dateTime(xgc.toGregorianCalendar());
    }

    public static String dateOnlyStamp() {
        return dateOnlyFmt.format(new Date());
    }

    public static String dateOnlyStamp(GregorianCalendar gc) {
        return gc == null ? "" : dateOnlyFmt.format(gc.getTime());
    }

    public static String dateOnlyStamp(Date date) {
        return date == null ? "" : dateOnlyFmt.format(date);
    }

    public static String dateOnlyStamp(XMLGregorianCalendar xgc) {
        return xgc == null ? "" : dateOnlyFmt.format(xgc.toGregorianCalendar().getTime());
    }

    public static String niceDateStamp() {
        return niceDateFmt.format(new Date());
    }

    public static String niceDateStamp(Date date) {
        return date == null ? "" : niceDateFmt.format(date);
    }

    public static String niceDateStamp(GregorianCalendar gc) {
        return gc == null ? "" : niceDateFmt.format(gc.getTime());
    }

    public static String niceDateStamp(XMLGregorianCalendar xgc) {
        return xgc == null ? "" : niceDateFmt.format(xgc.toGregorianCalendar().getTime());
    }

    public static long firstMomentOfDay(long utc) {
        GregorianCalendar begin = new GregorianCalendar();
        begin.setTimeInMillis(utc);
        return Chrono.firstMomentOfDay(begin).getTimeInMillis();
    }

    public static long lastMomentOfDay(long utc) {
        GregorianCalendar end = new GregorianCalendar();
        end.setTimeInMillis(utc);
        return Chrono.lastMomentOfDay(end).getTimeInMillis();
    }

    public static GregorianCalendar firstMomentOfDay(GregorianCalendar begin) {
        if (begin == null) {
            begin = new GregorianCalendar();
        }
        begin.set(10, 0);
        begin.set(9, 0);
        begin.set(12, 0);
        begin.set(13, 0);
        begin.set(14, 0);
        return begin;
    }

    public static GregorianCalendar lastMomentOfDay(GregorianCalendar end) {
        if (end == null) {
            end = new GregorianCalendar();
        }
        end.set(10, 11);
        end.set(12, 59);
        end.set(13, 59);
        end.set(14, 999);
        end.set(9, 1);
        return end;
    }

    public static final Date uuidToDate(UUID id) {
        return new Date((id.timestamp() - 122192928000000000L) / 10000L);
    }

    public static final long uuidToUnix(UUID id) {
        return (id.timestamp() - 122192928000000000L) / 10000L;
    }

    public static float millisFromNanos(long start, long end) {
        return (float)(end - start) / 1000000.0f;
    }

    private static synchronized long sequence() {
        return ++sequence;
    }

    public static final UUID dateToUUID(Date d) {
        long origTime = d.getTime();
        long time = origTime * 10000L + 122192928000000000L;
        long timeLow = time & 0xFFFFFFFFL;
        long timeMid = time & 0xFFFF00000000L;
        long timeHi = time & 0xFFF000000000000L;
        long upperLong = timeLow << 32 | timeMid >> 16 | 0x1000L | timeHi >> 48;
        return new UUID(upperLong, 0xC000000000000000L | Chrono.sequence());
    }

    static {
        try {
            xmlDatatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        dateOnlyFmt = new SimpleDateFormat("yyyy-MM-dd");
        niceDateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm zzz");
        dateFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        utcFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        utcFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        sequence = new Random().nextInt();
    }

    public static class Formatter8601
    extends Formatter {
        @Override
        public String format(LogRecord r) {
            StringBuilder sb = new StringBuilder();
            sb.append(dateFmt.format(new Date(r.getMillis())));
            sb.append(' ');
            sb.append(r.getThreadID());
            sb.append(' ');
            sb.append(r.getLevel());
            sb.append(": ");
            sb.append(r.getMessage());
            sb.append('\n');
            return sb.toString();
        }
    }
}

