/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import java.io.IOException;
import java.io.OutputStream;

public class DoubleOutputStream
extends OutputStream {
    private OutputStream[] oss;
    private boolean[] close;

    public DoubleOutputStream(OutputStream a, boolean closeA, OutputStream b, boolean closeB) {
        this.oss = new OutputStream[]{a, b};
        this.close = new boolean[]{closeA, closeB};
    }

    @Override
    public void write(int c) throws IOException {
        for (OutputStream os : this.oss) {
            os.write(c);
        }
    }

    @Override
    public void write(byte[] bbuf, int off, int len) throws IOException {
        for (OutputStream os : this.oss) {
            os.write(bbuf, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream os : this.oss) {
            os.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.oss.length; ++i) {
            if (!this.close[i]) continue;
            this.oss[i].close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream os : this.oss) {
            os.flush();
        }
    }
}

