/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    public static int INDENT = 2;
    private boolean addIndent = false;
    private int indent = 0;
    private int col = 0;

    public IndentPrintWriter(Writer out) {
        super(out);
    }

    public IndentPrintWriter(OutputStream out) {
        super(out);
    }

    @Override
    public void write(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(i));
        }
    }

    @Override
    public void println() {
        this.write(10);
    }

    @Override
    public void write(String str, int off, int len) {
        len = Math.min(str.length(), off + len);
        for (int i = off; i < len; ++i) {
            this.write(str.charAt(i));
        }
    }

    @Override
    public void write(int b) {
        if (b == 10) {
            this.addIndent = true;
            this.col = 0;
        } else if (this.addIndent) {
            this.addIndent = false;
            this.toIndent();
        } else {
            ++this.col;
        }
        super.write(b);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[i] + off);
        }
    }

    public void setIndent(int size) {
        this.indent = size;
    }

    public void inc() {
        ++this.indent;
    }

    public void dec() {
        --this.indent;
    }

    public void toCol(int idx) {
        while (idx > this.col++) {
            super.write(32);
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void toIndent() {
        int end = this.indent * INDENT;
        for (int i = 0; i < end; ++i) {
            super.write(32);
        }
        this.col = end;
    }
}

