/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import com.att.inno.env.APIException;
import com.att.inno.env.LogTarget;
import java.util.LinkedList;

public class Pool<T> {
    private static final int MAX_RANGE = 6;
    private LinkedList<Pooled<T>> list;
    private int count = 0;
    private int spares = 0;
    private int max_range = 6;
    private Creator<T> creator;

    public Pool(Creator<T> creator) {
        this.creator = creator;
        this.list = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prime(LogTarget lt, int prime) throws APIException {
        for (int i = 0; i < prime; ++i) {
            Pooled<T> pt = new Pooled<T>(this.creator.create(), this, lt);
            LinkedList<Pooled<T>> linkedList = this.list;
            synchronized (linkedList) {
                this.list.addFirst(pt);
                ++this.count;
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        LinkedList<Pooled<T>> linkedList = this.list;
        synchronized (linkedList) {
            for (int i = 0; i < this.list.size(); ++i) {
                Pooled<T> pt = this.list.remove();
                this.creator.destroy(pt.content);
                pt.logTarget.log("Pool drained ", this.creator.toString());
            }
            this.spares = 0;
            this.count = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pooled<T> get() throws APIException {
        Pooled<T> pt;
        LinkedList<Pooled<T>> linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.isEmpty()) {
                pt = null;
            } else {
                pt = this.list.removeLast();
                --this.count;
                this.creator.reuse(pt.content);
            }
        }
        if (pt == null) {
            if (this.spares < this.max_range) {
                ++this.spares;
            }
            pt = new Pooled<T>(this.creator.create(), this, LogTarget.NULL);
        } else if (this.spares > 1) {
            --this.spares;
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pooled<T> get(LogTarget lt) throws APIException {
        Pooled<T> pt;
        LinkedList<Pooled<T>> linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.isEmpty()) {
                pt = null;
            } else {
                pt = this.list.remove();
                --this.count;
                this.creator.reuse(pt.content);
            }
        }
        if (pt == null) {
            if (this.spares < this.max_range) {
                ++this.spares;
            }
            pt = new Pooled<T>(this.creator.create(), this, lt);
            lt.log("Pool created ", this.creator.toString());
        } else if (this.spares > 1) {
            --this.spares;
        }
        return pt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        boolean rv = true;
        LinkedList<Pooled<T>> linkedList = this.list;
        synchronized (linkedList) {
            for (Pooled pooled : this.list) {
                if (this.creator.isValid(pooled.content)) continue;
                rv = false;
                pooled.toss();
                this.list.remove(pooled);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offer(LogTarget lt, Pooled<T> used) {
        if (this.count < this.spares) {
            LinkedList<Pooled<T>> linkedList = this.list;
            synchronized (linkedList) {
                this.list.addFirst(used);
                ++this.count;
            }
            lt.log("Pool recovered ", this.creator.toString());
        } else {
            lt.log("Pool destroyed ", this.creator.toString());
            this.creator.destroy(used.content);
        }
        return false;
    }

    public int getMaxRange() {
        return this.max_range;
    }

    public void setMaxRange(int max_range) {
        this.max_range = Math.max(0, max_range);
    }

    public static class Pooled<T> {
        public final T content;
        private Pool<T> pool;
        protected LogTarget logTarget;

        public Pooled(T t, Pool<T> pool, LogTarget logTarget) {
            this.content = t;
            this.pool = pool;
            this.logTarget = logTarget;
        }

        public void done() {
            if (this.pool != null) {
                ((Pool)this.pool).offer(this.logTarget, this);
            }
        }

        public void toss() {
            if (this.pool != null) {
                ((Pool)this.pool).creator.destroy(this.content);
            }
            this.pool = null;
        }

        protected void finalize() throws Throwable {
            if (this.pool != null) {
                this.done();
                this.pool = null;
            }
        }
    }

    public static interface Creator<T> {
        public T create() throws APIException;

        public void destroy(T var1);

        public boolean isValid(T var1);

        public void reuse(T var1);
    }
}

