/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import com.att.inno.env.APIException;
import com.att.inno.env.Creatable;
import com.att.inno.env.Env;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RefreshableThreadObject<T extends Creatable<T>> {
    private Map<Thread, T> objs = Collections.synchronizedMap(new HashMap());
    private long refreshed;
    private Constructor<T> cnst;

    public RefreshableThreadObject(Class<T> clss) throws APIException {
        try {
            this.cnst = clss.getConstructor(Env.class);
        }
        catch (Exception e) {
            throw new APIException(e);
        }
    }

    public T get(Env env) throws APIException {
        Thread t = Thread.currentThread();
        Creatable obj = (Creatable)this.objs.get(t);
        if (obj == null || this.refreshed > obj.created()) {
            try {
                obj = (Creatable)this.cnst.newInstance(env);
            }
            catch (InvocationTargetException e) {
                throw new APIException(e.getTargetException());
            }
            catch (Exception e) {
                throw new APIException(e);
            }
            Creatable destroyMe = this.objs.put(t, obj);
            if (destroyMe != null) {
                destroyMe.destroy(env);
            }
        }
        return (T)obj;
    }

    public void refresh(Env env) {
        this.refreshed = System.currentTimeMillis();
    }

    public void remove(Env env) {
        Creatable obj = (Creatable)this.objs.remove(Thread.currentThread());
        if (obj != null) {
            obj.destroy(env);
        }
    }
}

