/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import java.io.IOException;
import java.io.OutputStream;

public class StringBuilderOutputStream
extends OutputStream {
    private StringBuilder buf;

    public StringBuilderOutputStream() {
        this.buf = new StringBuilder();
    }

    public StringBuilderOutputStream(StringBuilder sb) {
        this.buf = sb;
    }

    public StringBuilderOutputStream(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuilder(initialSize);
    }

    @Override
    public void write(int c) {
        this.buf.append((byte)c);
    }

    @Override
    public void write(byte[] bbuf, int off, int len) {
        if (off < 0 || off > bbuf.length || len < 0 || off + len > bbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(new String(bbuf, off, len));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buf.append(new String(b));
    }

    public void write(String str) {
        this.buf.append(str);
    }

    public void write(String str, int off, int len) {
        this.buf.append(str, off, len);
    }

    public StringBuilderOutputStream append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            for (int i = 0; i < csq.length(); ++i) {
                this.buf.append(csq.charAt(i));
            }
        }
        return this;
    }

    public StringBuilderOutputStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        return this.append(cs.subSequence(start, end));
    }

    public StringBuilderOutputStream append(byte c) {
        this.buf.append(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuilder getBuffer() {
        return this.buf;
    }

    public void reset() {
        this.buf.setLength(0);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

