/*
 * Decompiled with CFR 0.152.
 */
package com.att.inno.env.util;

import java.io.IOException;
import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private StringBuilder buf;

    public StringBuilderWriter() {
        this.buf = new StringBuilder();
    }

    public StringBuilderWriter(StringBuilder sb) {
        this.buf = sb;
    }

    public StringBuilderWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringBuilder(initialSize);
    }

    @Override
    public void write(int c) {
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.buf.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        char[] chars = new char[len];
        str.getChars(off, off + len, chars, 0);
        this.buf.append(chars);
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.buf.append(csq);
        }
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        return this.append(cs.subSequence(start, end));
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.buf.append(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringBuilder getBuffer() {
        return this.buf;
    }

    public void reset() {
        this.buf.setLength(0);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

