/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.inno.env.Env;
import com.att.inno.env.TimeTaken;
import com.att.rosetta.Parse;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import java.io.IOException;
import java.io.Reader;

public class InJson
implements Parse<Reader, State> {
    @Override
    public Parsed<State> parse(Reader r, Parsed<State> parsed) throws ParseException {
        State state = (State)parsed.state;
        if (state.unsent > '\u0000') {
            parsed.event = state.unsent;
            state.unsent = '\u0000';
            return parsed;
        }
        StringBuilder sb = parsed.sb;
        boolean inQuotes = false;
        boolean escaped = false;
        boolean go = true;
        try {
            int ch;
            block10: while (go && (ch = r.read()) >= 0) {
                if (state.braces < 0 && ch != 123) continue;
                char c = (char)ch;
                if (c == '\"') {
                    if (inQuotes) {
                        if (escaped) {
                            sb.append(c);
                            escaped = false;
                            continue;
                        }
                        inQuotes = false;
                        continue;
                    }
                    parsed.isString = true;
                    inQuotes = true;
                    continue;
                }
                if (inQuotes) {
                    if (c == '\\') {
                        escaped = !escaped;
                    }
                    sb.append(c);
                    continue;
                }
                switch (c) {
                    case ':': {
                        parsed.dataIsName();
                        parsed.isString = false;
                        continue block10;
                    }
                    case '{': {
                        if (state.braces++ == 0) {
                            parsed.event = '\u0001';
                            state.unsent = c;
                        } else {
                            parsed.event = c;
                        }
                        go = false;
                        continue block10;
                    }
                    case '}': {
                        if (--state.braces == 0) {
                            parsed.event = c;
                            state.unsent = (char)2;
                        } else {
                            parsed.event = c;
                        }
                        go = false;
                        continue block10;
                    }
                    case ',': {
                        if (parsed.name.startsWith("__")) {
                            parsed.event = (char)3;
                            parsed.name = parsed.name.substring(2);
                        } else {
                            parsed.event = c;
                        }
                        go = false;
                        continue block10;
                    }
                    case '[': 
                    case ']': {
                        parsed.event = c;
                        go = false;
                        continue block10;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\\': {
                        continue block10;
                    }
                }
                sb.append(c);
            }
            return parsed;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Parsed<State> newParsed() {
        return new Parsed<State>(new State());
    }

    @Override
    public TimeTaken start(Env env) {
        return env.start("Rosetta JSON In", 4);
    }

    public static class State {
        public int braces = 0;
        public char unsent = '\u0000';
    }
}

