/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.inno.env.Env;
import com.att.inno.env.TimeTaken;
import com.att.rosetta.JaxInfo;
import com.att.rosetta.Parse;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import com.att.rosetta.Prop;
import com.att.rosetta.XmlEscape;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class InXML
implements Parse<Reader, State> {
    JaxInfo jaxInfo;

    public InXML(JaxInfo jaxInfo) {
        this.jaxInfo = jaxInfo;
    }

    public InXML(Class<?> cls, String ... rootNs) throws SecurityException, NoSuchFieldException, ClassNotFoundException, ParseException {
        this.jaxInfo = JaxInfo.build(cls, rootNs);
    }

    @Override
    public Parsed<State> parse(Reader r, Parsed<State> parsed) throws ParseException {
        State state = (State)parsed.state;
        if (state.unevaluated != null) {
            DerTag dt = state.unevaluated;
            state.unevaluated = null;
            if (!state.greatExp.eval(parsed, dt)) {
                return parsed;
            }
        }
        if (state.hasAttributes()) {
            Prop prop = state.pop();
            parsed.event = (char)3;
            parsed.name = prop.tag;
            parsed.sb.append(prop.value);
            parsed.isString = true;
            return parsed;
        }
        boolean inQuotes = false;
        boolean escaped = false;
        StringBuilder sb = parsed.sb;
        StringBuilder tempSB = new StringBuilder();
        boolean go = true;
        try {
            int ch;
            block5: while (go && (ch = r.read()) >= 0) {
                char c = (char)ch;
                if (c == '\"') {
                    if (inQuotes) {
                        if (escaped) {
                            sb.append('\\');
                            sb.append(c);
                            escaped = false;
                            continue;
                        }
                        inQuotes = false;
                        continue;
                    }
                    parsed.isString = true;
                    inQuotes = true;
                    continue;
                }
                if (inQuotes) {
                    sb.append(c);
                    continue;
                }
                if (c == '&') {
                    XmlEscape.xmlEscape(sb, r);
                    continue;
                }
                switch (c) {
                    case '<': {
                        DerTag tag = new DerTag().parse(r, tempSB);
                        go = state.greatExp.eval(parsed, tag);
                        continue block5;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(c);
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                sb.append(c);
            }
            return parsed;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Parsed<State> newParsed() throws ParseException {
        return new Parsed<State>(new State(this.jaxInfo, null));
    }

    @Override
    public TimeTaken start(Env env) {
        return env.start("Rosetta XML In", 2);
    }

    private static class ArrayExpectations
    extends GreatExpectations {
        public ArrayExpectations(State state, JaxInfo ji, GreatExpectations prev) throws ParseException {
            super(state, ji, prev, null);
            if (state.arrayInfo == null) {
                state.arrayInfo = new Stack();
            }
            state.arrayInfo.push(new ArrayState());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean eval(Parsed<State> parsed, DerTag derTag) throws ParseException {
            if (this.ji.name.equals(derTag.name) && !derTag.isEndTag) {
                if (this.ji.isObject()) {
                    if (derTag.isEndTag) {
                        throw new ParseException("Unexpected End Tag </" + derTag.name + '>');
                    }
                    ArrayState ai = ((State)parsed.state).arrayInfo.peek();
                    if (!ai.firstObj && !ai.didNext) {
                        ai.didNext = true;
                        parsed.event = (char)44;
                        ((State)parsed.state).unevaluated = derTag;
                        return false;
                    }
                    ai.firstObj = false;
                    ai.didNext = false;
                    parsed.event = (char)123;
                    parsed.name = derTag.name;
                    ((State)parsed.state).greatExp = new ObjectExpectations((State)parsed.state, this.ji, this, true, derTag);
                    return false;
                }
                if (derTag.isEndTag) {
                    throw new ParseException("Misplaced End Tag </" + parsed.name + '>');
                }
                ((State)parsed.state).greatExp = new LeafExpectations((State)parsed.state, this.ji, this);
                return true;
            }
            ((State)parsed.state).unevaluated = derTag;
            parsed.event = (char)93;
            ((State)parsed.state).greatExp = this.prev;
            ((State)parsed.state).arrayInfo.pop();
            return false;
        }
    }

    private static class LeafExpectations
    extends GreatExpectations {
        public LeafExpectations(State state, JaxInfo curr, GreatExpectations prev) throws ParseException {
            super(state, curr, prev, null);
        }

        @Override
        public boolean eval(Parsed<State> parsed, DerTag derTag) throws ParseException {
            if (!this.ji.name.equals(derTag.name) || !derTag.isEndTag) {
                throw new ParseException("Expected </" + this.ji.name + '>');
            }
            parsed.event = (char)44;
            parsed.isString = this.ji.isString;
            ((State)parsed.state).greatExp = this.prev;
            return false;
        }
    }

    private static class ObjectExpectations
    extends GreatExpectations {
        private boolean printName;

        public ObjectExpectations(State state, JaxInfo curr, GreatExpectations prev, boolean printName, DerTag derTag) throws ParseException {
            super(state, curr, prev, derTag);
            this.printName = printName;
        }

        @Override
        public boolean eval(Parsed<State> parsed, DerTag derTag) throws ParseException {
            if (derTag.isEndTag && this.ji.name.equals(derTag.name)) {
                ((State)parsed.state).greatExp = this.prev;
                parsed.event = (char)125;
                if (this.printName) {
                    parsed.name = this.ji.name;
                }
            } else {
                for (JaxInfo memb : this.ji.members) {
                    if (!memb.name.equals(derTag.name)) continue;
                    parsed.name = memb.name;
                    if (memb.isArray) {
                        ((State)parsed.state).unevaluated = derTag;
                        parsed.event = (char)91;
                        ((State)parsed.state).greatExp = new ArrayExpectations((State)parsed.state, memb, this);
                        return false;
                    }
                    if (memb.isObject()) {
                        if (derTag.isEndTag) {
                            throw new ParseException("Unexpected End Tag </" + derTag.name + '>');
                        }
                        parsed.event = (char)123;
                        ((State)parsed.state).greatExp = new ObjectExpectations((State)parsed.state, memb, this, true, derTag);
                        return false;
                    }
                    if (derTag.isEndTag) {
                        throw new ParseException("Misplaced End Tag </" + parsed.name + '>');
                    }
                    ((State)parsed.state).greatExp = new LeafExpectations((State)parsed.state, memb, this);
                    return true;
                }
                throw new ParseException("Unexpected Tag <" + derTag.name + '>');
            }
            return false;
        }
    }

    private static class RootExpectations
    extends GreatExpectations {
        public RootExpectations(State state, JaxInfo curr, GreatExpectations prev) throws ParseException {
            super(state, curr, prev, null);
        }

        @Override
        public boolean eval(Parsed<State> parsed, DerTag derTag) throws ParseException {
            if (derTag.isXmlInfo) {
                parsed.event = '\u0001';
            } else if (this.ji.name.equals(derTag.name)) {
                if (derTag.isEndTag) {
                    parsed.event = (char)2;
                    ((State)parsed.state).greatExp = this.prev;
                } else {
                    parsed.event = (char)123;
                    ((State)parsed.state).greatExp = new ObjectExpectations((State)parsed.state, this.ji, this, false, derTag);
                }
            }
            return false;
        }
    }

    private static abstract class GreatExpectations {
        protected JaxInfo ji;
        protected GreatExpectations prev;
        private Map<String, String> ns;

        public GreatExpectations(State state, JaxInfo curr, GreatExpectations prev, DerTag derTag) throws ParseException {
            this.prev = prev;
            this.ns = null;
            this.ji = this.getDerived(state, curr, derTag);
        }

        public abstract boolean eval(Parsed<State> var1, DerTag var2) throws ParseException;

        protected Map<String, String> getNS() {
            if (this.ns != null) {
                return this.ns;
            }
            if (this.prev != null) {
                return this.prev.getNS();
            }
            return null;
        }

        private void addNS(Prop prop) {
            Map<String, String> existingNS = this.getNS();
            if (this.ns == null) {
                this.ns = new HashMap<String, String>();
            }
            if (existingNS != null && this.ns != existingNS) {
                this.ns.putAll(this.ns);
            }
            this.ns.put(prop.tag, prop.value);
        }

        private JaxInfo getDerived(State state, JaxInfo ji, DerTag derTag) throws ParseException {
            if (derTag == null) {
                return ji;
            }
            List<Prop> props = derTag.props;
            Prop derived = null;
            if (props != null) {
                for (Prop prop : props) {
                    if (!prop.tag.startsWith("xmlns:")) continue;
                    this.addNS(prop);
                }
                for (Prop prop : props) {
                    if (prop.tag.endsWith(":type")) {
                        int idx = prop.tag.indexOf(58);
                        String potentialNS = "xmlns:" + prop.tag.substring(0, idx);
                        Map<String, String> ns = this.getNS();
                        boolean noNamespace = false;
                        if (ns == null) {
                            noNamespace = true;
                        } else {
                            String nsVal = ns.get(potentialNS);
                            if (nsVal == null) {
                                noNamespace = true;
                            } else {
                                derived = new Prop("extension", prop.value);
                                state.push(derived);
                            }
                        }
                        if (!noNamespace) continue;
                        throw new ParseException(prop.tag + " utilizes an invalid Namespace prefix");
                    }
                    if (prop.tag.startsWith("xmlns")) continue;
                    state.push(prop);
                }
            }
            return derived == null ? ji : ji.getDerived(derived.value);
        }
    }

    public static class State {
        public GreatExpectations greatExp;
        public DerTag unevaluated;
        public Stack<ArrayState> arrayInfo;
        private List<Prop> attribs;
        private int idx;

        public State(JaxInfo ji, DerTag dt) throws ParseException {
            this.greatExp = new RootExpectations(this, ji, null);
            this.unevaluated = null;
            this.attribs = null;
        }

        public boolean hasAttributes() {
            return this.attribs != null && this.idx < this.attribs.size();
        }

        public void push(Prop prop) {
            if (this.attribs == null) {
                this.attribs = new ArrayList<Prop>();
                this.idx = 0;
            }
            this.attribs.add(prop);
        }

        public Prop pop() {
            Prop rv = null;
            if (this.attribs != null) {
                rv = this.attribs.get(this.idx++);
                if (this.idx >= this.attribs.size()) {
                    this.attribs = null;
                }
            }
            return rv;
        }
    }

    private static class ArrayState {
        public boolean firstObj = true;
        public boolean didNext = false;

        private ArrayState() {
        }
    }

    public static final class DerTag {
        public String name = null;
        public boolean isEndTag = false;
        public List<Prop> props = null;
        private boolean isXmlInfo = false;

        public DerTag parse(Reader r, StringBuilder sb) throws ParseException {
            boolean inQuotes = false;
            boolean escaped = false;
            boolean go = true;
            String tag = null;
            try {
                int ch = r.read();
                if (ch < 0) {
                    throw new ParseException("Reader content ended before complete");
                }
                if (ch == 63) {
                    this.isXmlInfo = true;
                }
                block9: do {
                    char c;
                    if ((c = (char)ch) == '\"') {
                        if (inQuotes) {
                            if (escaped) {
                                sb.append(c);
                                escaped = false;
                                continue;
                            }
                            inQuotes = false;
                            continue;
                        }
                        inQuotes = true;
                        continue;
                    }
                    if (inQuotes) {
                        sb.append(c);
                        continue;
                    }
                    switch (c) {
                        case '/': {
                            this.isEndTag = true;
                            break;
                        }
                        case ' ': {
                            this.endField(tag, sb);
                            tag = null;
                            break;
                        }
                        case '>': {
                            this.endField(tag, sb);
                            go = false;
                            break;
                        }
                        case '=': {
                            tag = sb.toString();
                            sb.setLength(0);
                            break;
                        }
                        case '?': {
                            if (this.isXmlInfo) continue block9;
                            sb.append(c);
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                } while (go && (ch = r.read()) >= 0);
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
            return this;
        }

        private void endField(String tag, StringBuilder sb) {
            if (this.name == null) {
                this.name = sb.toString();
                sb.setLength(0);
            } else {
                String value = sb.toString();
                sb.setLength(0);
                if (tag != null && value != null) {
                    if (this.props == null) {
                        this.props = new ArrayList<Prop>();
                    }
                    this.props.add(new Prop(tag, value));
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.isEndTag ? "End" : "Start");
            sb.append(" Tag\n");
            sb.append("  Name: ");
            sb.append(this.name);
            if (this.props != null) {
                for (Prop p : this.props) {
                    sb.append("\n     ");
                    sb.append(p.tag);
                    sb.append("=\"");
                    sb.append(p.value);
                    sb.append('\"');
                }
            }
            return sb.toString();
        }
    }
}

