/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.rosetta.ParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

public class JaxInfo {
    private static final String DEFAULT = "##default";
    public static final int DATA = 0;
    public static final int ARRAY = 1;
    public static final int OBJECT = 2;
    public final String name;
    public final Class<?> clss;
    public Map<String, JaxInfo> extensions;
    public final JaxInfo[] members;
    public final boolean isArray;
    public final boolean isString;
    public final boolean required;
    public final boolean nillable;
    public String ns;

    public boolean isObject() {
        return this.members != null;
    }

    private JaxInfo(String n, String ns, Class<?> c, JaxInfo[] members, boolean string, boolean array, boolean required, boolean nillable) {
        this.name = n;
        this.ns = ns;
        this.clss = c;
        this.members = members;
        this.isString = string;
        this.isArray = array;
        this.required = required;
        this.nillable = nillable;
        this.extensions = null;
    }

    public int getType() {
        if (this.isArray) {
            return 1;
        }
        if (this.members != null) {
            return 2;
        }
        return 0;
    }

    public JaxInfo getDerived(String derivedName) {
        JaxInfo derived;
        if (this.extensions == null) {
            this.extensions = new HashMap<String, JaxInfo>();
            derived = null;
        } else {
            derived = this.extensions.get(derivedName);
        }
        if (derived == null) {
            Package pkg = this.clss.getPackage();
            try {
                Class<?> dc = this.getClass().getClassLoader().loadClass(pkg.getName() + '.' + Character.toUpperCase(derivedName.charAt(0)) + derivedName.substring(1));
                derived = JaxInfo.build(dc, this);
                this.extensions.put(derivedName, derived);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return derived;
    }

    public static JaxInfo get(JaxInfo[] fields, String name) {
        for (JaxInfo f : fields) {
            if (!name.equals(f.name)) continue;
            return f;
        }
        return null;
    }

    public static JaxInfo build(Class<?> cls, JaxInfo parent) throws NoSuchFieldException, ClassNotFoundException, ParseException {
        return new JaxInfo(parent.name, parent.ns, cls, JaxInfo.buildFields(cls, parent.ns), parent.isString, parent.isArray, parent.required, parent.nillable);
    }

    public static JaxInfo build(Class<?> cls, String ... rootNns) throws SecurityException, NoSuchFieldException, ClassNotFoundException, ParseException {
        String name;
        String defaultNS;
        if (rootNns.length > 0 && rootNns[0] != null) {
            defaultNS = rootNns[0];
        } else {
            Package pkg = cls.getPackage();
            XmlSchema xs = pkg.getAnnotation(XmlSchema.class);
            String string = defaultNS = xs == null ? "" : xs.namespace();
        }
        if (rootNns.length > 1) {
            name = rootNns[1];
        } else {
            XmlRootElement xre = cls.getAnnotation(XmlRootElement.class);
            if (xre != null) {
                name = xre.name();
            } else {
                XmlType xt = cls.getAnnotation(XmlType.class);
                if (xt != null) {
                    name = xt.name();
                } else {
                    throw new ParseException("Need a JAXB Object with XmlRootElement, or stipulate in parms");
                }
            }
        }
        return new JaxInfo(name, defaultNS, cls, JaxInfo.buildFields(cls, defaultNS), false, false, false, false);
    }

    private static JaxInfo[] buildFields(Class<?> clazz, String defaultNS) throws SecurityException, NoSuchFieldException, ClassNotFoundException {
        XmlType xt;
        ArrayList<JaxInfo> fields = null;
        Class<?> cls = clazz;
        while ((xt = cls.getAnnotation(XmlType.class)) != null) {
            if (fields == null) {
                fields = new ArrayList<JaxInfo>();
            }
            for (String field : xt.propOrder()) {
                if ("".equals(field)) break;
                Field rf = cls.getDeclaredField(field);
                Class<List> ft = rf.getType();
                boolean required = false;
                boolean nillable = false;
                String xmlName = field;
                String namespace = defaultNS;
                XmlElement xe = rf.getAnnotation(XmlElement.class);
                if (xe != null) {
                    xmlName = xe.name();
                    required = xe.required();
                    nillable = false;
                    if (DEFAULT.equals(xmlName)) {
                        xmlName = field;
                    }
                    if (DEFAULT.equals(namespace = xe.namespace())) {
                        namespace = defaultNS;
                    }
                }
                if (ft.isAssignableFrom(List.class)) {
                    int end;
                    int start;
                    Type t = rf.getGenericType();
                    String classname = t.toString();
                    Class<?> genClass = Class.forName(classname.substring((start = classname.indexOf(60)) + 1, end = classname.indexOf(62)));
                    xe = genClass.getAnnotation(XmlElement.class);
                    if (xe != null && !DEFAULT.equals(xe.namespace())) {
                        namespace = xe.namespace();
                    }
                    fields.add(new JaxInfo(xmlName, namespace, genClass, JaxInfo.buildFields(genClass, namespace), genClass.equals(String.class), true, required, nillable));
                    continue;
                }
                boolean isString = ft.equals(String.class) || ft.equals(XMLGregorianCalendar.class);
                fields.add(new JaxInfo(xmlName, namespace, ft, JaxInfo.buildFields(ft, namespace), isString, false, required, nillable));
            }
            cls = cls.getSuperclass();
        }
        if (fields != null) {
            JaxInfo[] rv = new JaxInfo[fields.size()];
            fields.toArray(rv);
            return rv;
        }
        return null;
    }

    public StringBuilder dump(StringBuilder sb, int idx) {
        for (int i = 0; i < idx; ++i) {
            sb.append(' ');
        }
        sb.append("Field ");
        sb.append(this.name);
        sb.append(" [");
        sb.append(this.clss.getName());
        sb.append("] ");
        if (this.isArray) {
            sb.append(" (array)");
        }
        if (this.required) {
            sb.append(" (required)");
        }
        if (this.nillable) {
            sb.append(" (nillable)");
        }
        if (this.members != null) {
            for (JaxInfo f : this.members) {
                sb.append('\n');
                f.dump(sb, idx + 2);
            }
        }
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Structure of ");
        sb.append(this.clss.getName());
        sb.append('\n');
        this.dump(sb, 2);
        return sb.toString();
    }
}

