/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.rosetta.ParseException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlType;

public class JaxSet<T> {
    private static Map<Class<?>, JaxSet<?>> jsets = new HashMap();
    private Map<String, Setter<T>> members = new TreeMap<String, Setter<T>>();

    private JaxSet(Class<?> cls) {
        XmlType xmltype = cls.getAnnotation(XmlType.class);
        Class[] paramType = new Class[]{String.class};
        for (String str : xmltype.propOrder()) {
            try {
                String setName = "set" + Character.toUpperCase(str.charAt(0)) + str.subSequence(1, str.length());
                Method meth = cls.getMethod(setName, paramType);
                if (meth == null) continue;
                this.members.put(str, new Setter<T>(meth){

                    @Override
                    public void set(T o, Object t) throws ParseException {
                        try {
                            this.meth.invoke(o, t);
                        }
                        catch (Exception e) {
                            throw new ParseException(e);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> JaxSet<X> get(Class<?> cls) {
        Map<Class<?>, JaxSet<?>> map = jsets;
        synchronized (map) {
            JaxSet<Object> js = jsets.get(cls);
            if (js == null) {
                js = new JaxSet(cls);
                jsets.put(cls, js);
            }
            return js;
        }
    }

    public Setter<T> get(String key) {
        return this.members.get(key);
    }

    public static abstract class Setter<O> {
        protected final Method meth;

        public Setter(Method meth) {
            this.meth = meth;
        }

        public abstract void set(O var1, Object var2) throws ParseException;
    }
}

