/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

public class Ladder<T> {
    public static final int DEFAULT_INIT_SIZE = 8;
    private final int init_size;
    private int rung = 0;
    private Object[] struts;

    public Ladder() {
        this.init_size = 8;
        this.struts = new Object[this.init_size];
    }

    public Ladder(int initSize) {
        this.init_size = initSize;
        this.struts = new Object[this.init_size];
    }

    public void bottom() {
        this.rung = 0;
    }

    public void top() {
        this.rung = this.struts.length - 1;
        while (this.rung > 0 && this.struts[this.rung] == null) {
            --this.rung;
        }
    }

    public int howHigh() {
        return this.rung;
    }

    public void jumpTo(int rung) {
        if (rung >= this.struts.length) {
            Object[] temp = new Object[this.init_size * (rung / this.init_size + 1)];
            System.arraycopy(this.struts, 0, temp, 0, this.struts.length);
            this.struts = temp;
        }
        this.rung = rung;
    }

    public int height() {
        return this.struts.length;
    }

    public void cutTo(int rungs) {
        Object[] temp = new Object[rungs];
        System.arraycopy(this.struts, 0, temp, 0, Math.min(rungs, this.struts.length));
        this.struts = temp;
    }

    public void ascend() {
        ++this.rung;
        if (this.rung >= this.struts.length) {
            Object[] temp = new Object[this.struts.length + this.init_size];
            System.arraycopy(this.struts, 0, temp, 0, this.struts.length);
            this.struts = temp;
        }
    }

    public void descend() {
        --this.rung;
    }

    public T peek() {
        return (T)this.struts[this.rung];
    }

    public void push(T t) {
        this.struts[this.rung] = t;
    }

    public T pop() {
        Object t = this.struts[this.rung];
        this.struts[this.rung] = null;
        return (T)t;
    }
}

