/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.inno.env.util.IndentPrintWriter;
import com.att.rosetta.Out;
import com.att.rosetta.Parse;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class OutJson
extends Out {
    @Override
    public <IN, S> void extract(IN in, Writer writer, Parse<IN, S> prs, boolean ... options) throws IOException, ParseException {
        IndentPrintWriter ipw;
        Parsed<S> p = prs.newParsed();
        if (options.length > 0 && options[0]) {
            ipw = writer instanceof IndentPrintWriter ? (IndentPrintWriter)writer : new IndentPrintWriter(writer);
            writer = ipw;
        } else {
            ipw = null;
        }
        Stack<LevelStack> jsonLevel = new Stack<LevelStack>();
        jsonLevel.push(new LevelStack(options.length > 1 && options[1]));
        boolean print = true;
        boolean hadData = false;
        char afterName = '\u0000';
        char beforeName = '\u0000';
        int maybe = 0;
        int prev = 0;
        int count = 0;
        block18: while ((p = prs.parse(in, p.reuse())).valid()) {
            ++count;
            switch (p.event) {
                case '\u0001': {
                    continue block18;
                }
                case '\u0002': {
                    if (count == 2) {
                        writer.append('{');
                        writer.append('}');
                    }
                    writer.flush();
                    return;
                }
                case '{': {
                    afterName = '{';
                    print = ((LevelStack)jsonLevel.peek()).printObjectName;
                    maybe = ((LevelStack)jsonLevel.peek()).listItem();
                    jsonLevel.push(new LevelStack(true));
                    break;
                }
                case '}': {
                    if (p.hasData()) {
                        maybe = ((LevelStack)jsonLevel.peek()).listItem();
                    } else {
                        p.name = "";
                    }
                    print = true;
                    jsonLevel.pop();
                    afterName = p.event;
                    break;
                }
                case '[': {
                    afterName = p.event;
                    maybe = prev == 44 && !hadData || prev == 93 ? 44 : (int)((LevelStack)jsonLevel.peek()).listItem();
                    jsonLevel.push(new LevelStack(false));
                    print = true;
                    break;
                }
                case ']': {
                    afterName = p.event;
                    if (p.hasData()) {
                        maybe = prev == 44 && !hadData ? 44 : (int)((LevelStack)jsonLevel.peek()).listItem();
                    } else {
                        p.name = "";
                    }
                    jsonLevel.pop();
                    print = true;
                    break;
                }
                case '\u0003': 
                case ',': {
                    if (!p.hasData()) {
                        p.isString = false;
                        print = false;
                        break;
                    }
                    maybe = ((LevelStack)jsonLevel.peek()).listItem();
                    print = true;
                    break;
                }
                default: {
                    print = true;
                }
            }
            if (maybe != 0) {
                if (ipw == null) {
                    writer.append((char)maybe);
                } else {
                    ipw.println((char)maybe);
                }
                maybe = 0;
            }
            if (beforeName != '\u0000') {
                if (ipw == null) {
                    writer.append(beforeName);
                } else {
                    ipw.println(beforeName);
                }
                beforeName = '\u0000';
            }
            if (print) {
                if (p.hasName()) {
                    writer.append('\"');
                    if (p.event == '\u0003') {
                        writer.append("__");
                    }
                    writer.append(p.name);
                    writer.append("\":");
                }
                if (p.hasData()) {
                    if (p.isString) {
                        writer.append('\"');
                        this.escapedWrite(writer, p.sb);
                        writer.append('\"');
                    } else if (p.sb.length() > 0) {
                        writer.append(p.sb);
                    }
                }
            }
            if (afterName != '\u0000') {
                if (ipw == null) {
                    writer.append(afterName);
                } else {
                    switch (afterName) {
                        case '{': {
                            ipw.println(afterName);
                            ipw.inc();
                            break;
                        }
                        case '}': {
                            ipw.dec();
                            ipw.println();
                            ipw.print(afterName);
                            break;
                        }
                        case ']': {
                            if (prev == 125 || prev == 44) {
                                ipw.println();
                            }
                            ipw.dec();
                            ipw.print(afterName);
                            break;
                        }
                        case ',': {
                            ipw.println(afterName);
                            break;
                        }
                        default: {
                            ipw.print(afterName);
                        }
                    }
                }
                afterName = '\u0000';
            }
            if (ipw != null) {
                switch (p.event) {
                    case '[': {
                        ipw.inc();
                        ipw.println();
                    }
                }
            }
            prev = p.event;
            hadData = p.hasData();
        }
        writer.flush();
    }

    private void escapedWrite(Writer writer, StringBuilder sb) throws IOException {
        block4: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append(c);
                    if (i >= sb.length()) continue block4;
                    c = sb.charAt(++i);
                    writer.append(c);
                    continue block4;
                }
                case '\"': {
                    writer.append('\\');
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    @Override
    public String logName() {
        return "Rosetta JSON";
    }

    private static class LevelStack {
        public boolean printObjectName = false;
        private boolean first_n_List = true;

        public LevelStack(boolean printObjectName) {
            this.printObjectName = printObjectName;
        }

        public char listItem() {
            if (this.first_n_List) {
                this.first_n_List = false;
                return '\u0000';
            }
            return ',';
        }
    }
}

