/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.inno.env.util.IndentPrintWriter;
import com.att.inno.env.util.StringBuilderWriter;
import com.att.rosetta.InXML;
import com.att.rosetta.JaxInfo;
import com.att.rosetta.Out;
import com.att.rosetta.Parse;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import com.att.rosetta.Prop;
import com.att.rosetta.XmlEscape;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class OutXML
extends Out {
    private static final String XMLNS_XSI = "xmlns:xsi";
    public static final String XML_INFO = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    public static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private String root;
    private List<Prop> props;

    public OutXML(String root, String ... params) {
        this.root = root;
        this.props = new ArrayList<Prop>();
        for (String p : params) {
            String[] tv = p.split("=");
            if (tv.length != 2) continue;
            this.props.add(new Prop(tv[0], tv[1]));
        }
    }

    public OutXML(JaxInfo jaxInfo) {
        this(jaxInfo.name, OutXML.genNS(jaxInfo));
    }

    public OutXML(InXML inXML) {
        this(inXML.jaxInfo.name, OutXML.genNS(inXML.jaxInfo));
    }

    private static String[] genNS(JaxInfo jaxInfo) {
        return new String[]{"xmlns=" + jaxInfo.ns};
    }

    @Override
    public <IN, S> void extract(IN in, Writer writer, Parse<IN, S> prs, boolean ... options) throws IOException, ParseException {
        IndentPrintWriter ipw;
        boolean pretty;
        Parsed<S> p = prs.newParsed();
        Stack<Level> stack = new Stack<Level>();
        boolean bl = pretty = options.length > 0 && options[0];
        if (pretty) {
            if (writer instanceof IndentPrintWriter) {
                ipw = (IndentPrintWriter)writer;
            } else {
                ipw = new IndentPrintWriter(writer);
                writer = ipw;
            }
        } else {
            ipw = null;
        }
        boolean closeTag = false;
        Level level = new Level(null);
        while ((p = prs.parse(in, p.reuse())).valid()) {
            if (!p.hasName() && level.multi != null) {
                p.name = level.multi;
            }
            if (closeTag && p.event != '\u0003') {
                writer.append('>');
                if (pretty) {
                    writer.append('\n');
                }
                closeTag = false;
            }
            switch (p.event) {
                case '\u0001': {
                    if (options.length > 1 && options[1]) break;
                    if (pretty) {
                        ipw.println(XML_INFO);
                        break;
                    }
                    writer.append(XML_INFO);
                    break;
                }
                case '\u0002': {
                    break;
                }
                case '{': {
                    stack.push(level);
                    level = new Level(level);
                    if (p.hasName()) {
                        closeTag = this.tag(writer, level.sbw, pretty, pretty, p.name, null);
                    } else if (this.root != null && stack.size() == 1) {
                        closeTag = this.tag(writer, level.sbw, pretty, pretty, this.root, null);
                        for (Prop prop : this.props) {
                            this.attrib(writer, pretty, prop.tag, prop.value, level);
                        }
                    }
                    if (!pretty) break;
                    ipw.inc();
                    break;
                }
                case '}': {
                    if (p.hasData()) {
                        closeTag = this.tag(writer, writer, pretty, false, p.name, XmlEscape.convert(p.sb));
                    }
                    if (pretty) {
                        ipw.dec();
                    }
                    writer.append(level.sbw.getBuffer());
                    level = (Level)stack.pop();
                    break;
                }
                case '[': {
                    level.multi = p.name;
                    break;
                }
                case ']': {
                    if (p.hasData()) {
                        closeTag = this.tag(writer, writer, pretty, false, p.name, XmlEscape.convert(p.sb));
                    }
                    level.multi = null;
                    break;
                }
                case '\u0003': {
                    if (!p.hasData()) break;
                    this.attrib(writer, pretty, p.name, XmlEscape.convert(p.sb), level);
                    break;
                }
                case ',': {
                    if (!p.hasData()) break;
                    closeTag = this.tag(writer, writer, pretty, false, p.name, XmlEscape.convert(p.sb));
                }
            }
        }
        writer.append(level.sbw.getBuffer());
        writer.flush();
    }

    private boolean tag(Writer fore, Writer aft, boolean pretty, boolean returns, String tag, String data) throws IOException {
        fore.append('<');
        fore.append(tag);
        if (data != null) {
            fore.append('>');
            fore.append(data);
            if (returns) {
                fore.append('\n');
            }
        }
        aft.append("</");
        aft.append(tag);
        aft.append(">");
        if (pretty) {
            aft.append('\n');
        }
        return data == null;
    }

    private void attrib(Writer fore, boolean pretty, String tag, String value, Level level) throws IOException {
        String realTag;
        String string = realTag = tag.startsWith("__") ? tag.substring(2) : tag;
        if (realTag.equals("extension")) {
            fore.append(" xsi:type=\"");
            fore.append(value);
            fore.append('\"');
            if (!level.hasPrinted(XMLNS_XSI, XML_SCHEMA_INSTANCE, true)) {
                fore.append(' ');
                fore.append(XMLNS_XSI);
                fore.append("=\"");
                fore.append(XML_SCHEMA_INSTANCE);
                fore.append("\"");
            }
        } else {
            if (realTag.startsWith("xmlns:") && level.hasPrinted(realTag, value, true)) {
                return;
            }
            fore.append(' ');
            fore.append(realTag);
            fore.append("=\"");
            fore.append(value);
            fore.append('\"');
        }
    }

    @Override
    public String logName() {
        return "Rosetta XML";
    }

    private class Level {
        public final StringBuilderWriter sbw = new StringBuilderWriter();
        public String multi = null;
        private Level prev;
        private Map<String, String> nses;

        public Level(Level level) {
            this.prev = level;
        }

        public boolean hasPrinted(String ns, String value, boolean create) {
            boolean rv = false;
            if (this.nses == null) {
                if (this.prev != null) {
                    rv = this.prev.hasPrinted(ns, value, false);
                }
            } else {
                String v = this.nses.get(ns);
                return value.equals(v);
            }
            if (create && !rv) {
                if (this.nses == null) {
                    this.nses = new HashMap<String, String>();
                }
                this.nses.put(ns, value);
            }
            return rv;
        }
    }
}

