/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta;

import com.att.inno.env.Env;
import com.att.inno.env.TimeTaken;
import com.att.rosetta.Out;
import com.att.rosetta.Parse;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import com.att.rosetta.Prop;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public class Saved
extends Out
implements Parse<Reader, State> {
    private static final String ROSETTA_SAVED = "Rosetta Saved";
    private static final int INIT_SIZE = 128;
    private Content[] content;
    private int idx;
    private boolean append = false;

    @Override
    public <IN, S> void extract(IN in, Writer ignore, Parse<IN, S> parser, boolean ... options) throws IOException, ParseException {
        Parsed<S> p = parser.newParsed();
        if (!this.append) {
            if (this.content == null || this.content.length > 384) {
                this.content = new Content[128];
                this.idx = -1;
            } else {
                do {
                    this.content[this.idx] = null;
                } while (--this.idx >= 0);
            }
        }
        while ((p = parser.parse(in, p.reuse())).valid()) {
            if (this.append && (p.event == '\u0001' || p.event == '\u0002')) continue;
            if (++this.idx >= this.content.length) {
                Content[] temp = new Content[this.content.length * 2];
                System.arraycopy(this.content, 0, temp, 0, this.idx);
                this.content = temp;
            }
            this.content[this.idx] = new Content(p);
        }
    }

    @Override
    public Parsed<State> parse(Reader ignore, Parsed<State> parsed) throws ParseException {
        int i;
        if ((i = ((State)parsed.state).count++) <= this.idx) {
            this.content[i].load(parsed);
        } else {
            parsed.event = '\u0000';
        }
        return parsed;
    }

    public Content[] cut(char event, int count) {
        this.append = true;
        for (int i = this.idx; i >= 0; --i) {
            if (this.content[i].event == event) {
                --count;
            }
            if (count != 0) continue;
            Content[] appended = new Content[this.idx - i + 1];
            System.arraycopy(this.content, i, appended, 0, appended.length);
            this.idx = i - 1;
            return appended;
        }
        return new Content[0];
    }

    public void paste(Content[] appended) {
        if (appended != null) {
            if (this.idx + appended.length > this.content.length) {
                Content[] temp = new Content[this.content.length * 2];
                System.arraycopy(this.content, 0, temp, 0, this.idx);
                this.content = temp;
            }
            System.arraycopy(appended, 0, this.content, this.idx + 1, appended.length);
            this.idx += appended.length;
        }
        this.append = false;
    }

    @Override
    public Parsed<State> newParsed() {
        Parsed<State> ps = new Parsed<State>(new State());
        return ps;
    }

    public <IN, S> void load(IN in, Parse<IN, S> parser) throws IOException, ParseException {
        this.extract(in, (Writer)null, parser, new boolean[0]);
    }

    @Override
    public TimeTaken start(Env env) {
        return env.start(ROSETTA_SAVED, 0);
    }

    @Override
    public String logName() {
        return ROSETTA_SAVED;
    }

    public static class Content {
        private boolean isString;
        private char event;
        private String name;
        private List<Prop> props;
        private String str;

        public Content(Parsed<?> p) {
            this.isString = p.isString;
            this.event = p.event;
            this.name = p.name;
            this.str = p.sb.length() == 0 ? null : p.sb.toString();
        }

        public void load(Parsed<State> p) {
            p.isString = this.isString;
            p.event = this.event;
            p.name = this.name;
            if (this.str != null) {
                p.sb.append(this.str);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.event);
            sb.append(" - ");
            sb.append(this.name);
            sb.append(": ");
            if (this.isString) {
                sb.append('\"');
            }
            sb.append(this.str);
            if (this.isString) {
                sb.append('\"');
            }
            sb.append(' ');
            if (this.props != null) {
                boolean comma = false;
                for (Prop prop : this.props) {
                    if (comma) {
                        sb.append(',');
                    } else {
                        comma = true;
                    }
                    sb.append(prop.tag);
                    sb.append('=');
                    sb.append(prop.value);
                }
            }
            return sb.toString();
        }
    }

    public static class State {
        public int count = 0;
    }
}

