/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta.env;

import com.att.inno.env.APIException;
import com.att.inno.env.BaseDataFactory;
import com.att.inno.env.Data;
import com.att.inno.env.DataFactory;
import com.att.inno.env.Env;
import com.att.inno.env.TimeTaken;
import com.att.inno.env.Trans;
import com.att.inno.env.jaxb.JAXBmar;
import com.att.inno.env.jaxb.JAXBumar;
import com.att.rosetta.InJson;
import com.att.rosetta.InXML;
import com.att.rosetta.JaxInfo;
import com.att.rosetta.Marshal;
import com.att.rosetta.Out;
import com.att.rosetta.OutJson;
import com.att.rosetta.OutRaw;
import com.att.rosetta.OutXML;
import com.att.rosetta.Parse;
import com.att.rosetta.env.RosettaData;
import com.att.rosetta.env.RosettaEnv;
import com.att.rosetta.marshal.DocMarshal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;

public class RosettaDF<T>
extends BaseDataFactory
implements DataFactory<T> {
    static InJson inJSON = new InJson();
    InXML inXML;
    static OutJson outJSON = new OutJson();
    OutXML outXML;
    static OutRaw outRAW = new OutRaw();
    JAXBmar jaxMar;
    JAXBumar jaxUmar;
    private Parse<Reader, ?> defaultIn;
    private Out defaultOut;
    private RosettaEnv env;
    private Data.TYPE inType;
    private Data.TYPE outType;
    private int defOption;
    Marshal<T> marshal = null;

    RosettaDF(RosettaEnv env, Schema schema, String rootNs, Class<T> cls) throws APIException {
        this.env = env;
        try {
            JaxInfo ji = rootNs == null ? JaxInfo.build(cls, new String[0]) : JaxInfo.build(cls, rootNs);
            this.jaxMar = new JAXBmar(rootNs == null ? null : new QName("xmlns", rootNs), cls);
            this.jaxUmar = new JAXBumar(schema, cls);
            this.defaultIn = this.inXML = new InXML(ji);
            this.outXML = new OutXML(ji);
            this.defaultOut = this.outXML;
            this.inType = this.outType = Data.TYPE.XML;
            this.defOption = 0;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
    }

    @Override
    public RosettaData<T> newData() {
        Data data = ((RosettaData)((RosettaData)new RosettaData(this.env, this).in(this.inType)).out(this.outType)).option(this.defOption);
        return data;
    }

    @Override
    public RosettaData<T> newData(Env trans) {
        Data data = ((RosettaData)((RosettaData)new RosettaData(trans, this).in(this.inType)).out(this.outType)).option(this.defOption);
        return data;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.jaxMar.getMarshalClass();
    }

    public RosettaDF<T> in(Data.TYPE type) {
        this.inType = type;
        this.defaultIn = this.getIn(type == Data.TYPE.DEFAULT ? Data.TYPE.JSON : type);
        return this;
    }

    public RosettaDF<T> out(Data.TYPE type) {
        this.outType = type;
        this.defaultOut = this.getOut(type == Data.TYPE.DEFAULT ? Data.TYPE.JSON : type);
        return this;
    }

    public Parse<Reader, ?> getIn(Data.TYPE type) {
        switch (type) {
            case DEFAULT: {
                return this.defaultIn;
            }
            case JSON: {
                return inJSON;
            }
            case XML: {
                return this.inXML;
            }
        }
        return this.defaultIn;
    }

    public Out getOut(Data.TYPE type) {
        switch (type) {
            case DEFAULT: {
                return this.defaultOut;
            }
            case JSON: {
                return outJSON;
            }
            case XML: {
                return this.outXML;
            }
            case RAW: {
                return outRAW;
            }
        }
        return this.defaultOut;
    }

    public int logType(Data.TYPE ot) {
        switch (ot) {
            case JSON: {
                return 4;
            }
        }
        return 2;
    }

    public RosettaEnv getEnv() {
        return this.env;
    }

    public Data.TYPE getInType() {
        return this.inType;
    }

    public Data.TYPE getOutType() {
        return this.outType;
    }

    public RosettaDF<T> option(int option) {
        this.defOption = option;
        return this;
    }

    public RosettaDF<T> rootMarshal(Marshal<T> marshal) {
        this.marshal = marshal instanceof DocMarshal ? marshal : DocMarshal.root(marshal);
        return this;
    }

    public void direct(Trans trans, T t, OutputStream os, boolean ... options) throws APIException, IOException {
        Out out = this.getOut(this.outType);
        TimeTaken tt = trans.start(out.logName(), this.logType(this.outType));
        try {
            if (this.marshal == null) {
                StringWriter sw = new StringWriter();
                this.jaxMar.marshal(trans.debug(), t, (Writer)sw, options);
                out.extract(new StringReader(sw.toString()), new OutputStreamWriter(os), this.inXML, options);
            } else {
                out.extract(t, new OutputStreamWriter(os), this.marshal, options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    public void direct(Trans trans, T t, Writer writer, boolean ... options) throws APIException, IOException {
        Out out = this.getOut(this.outType);
        TimeTaken tt = trans.start(out.logName(), this.logType(this.outType));
        try {
            if (this.marshal == null) {
                StringWriter sw = new StringWriter();
                this.jaxMar.marshal(trans.debug(), t, (Writer)sw, options);
                out.extract(new StringReader(sw.toString()), writer, this.inXML, options);
            } else {
                out.extract(t, writer, this.marshal, options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }
}

