/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta.env;

import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.inno.env.Env;
import com.att.inno.env.TimeTaken;
import com.att.rosetta.Out;
import com.att.rosetta.Parse;
import com.att.rosetta.Saved;
import com.att.rosetta.env.RosettaDF;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class RosettaData<T>
implements Data<T> {
    private Env trans;
    private RosettaDF<T> df;
    private Saved saved;
    private Data.TYPE inType;
    private Data.TYPE outType;
    private boolean[] options = new boolean[]{false, false};
    private String xml;
    private String json;
    private static final boolean[] emptyOption = new boolean[0];

    RosettaData(Env env, RosettaDF<T> rosettaDF) {
        this.df = rosettaDF;
        this.saved = new Saved();
        this.trans = env;
        this.inType = this.df.getInType();
        this.outType = this.df.getOutType();
    }

    @Override
    public RosettaData<T> in(Data.TYPE rosettaType) {
        this.inType = rosettaType;
        return this;
    }

    @Override
    public RosettaData<T> out(Data.TYPE rosettaType) {
        this.outType = rosettaType;
        return this;
    }

    @Override
    public RosettaData<T> load(Reader rdr) throws APIException {
        Parse<Reader, ?> in = this.df.getIn(this.inType);
        TimeTaken tt = in.start(this.trans);
        try {
            this.saved.extract(rdr, (Writer)null, in, new boolean[0]);
            this.json = null;
            this.xml = null;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
        return this;
    }

    @Override
    public RosettaData<T> load(InputStream is) throws APIException {
        Parse<Reader, ?> in = this.df.getIn(this.inType);
        TimeTaken tt = in.start(this.trans);
        try {
            this.saved.extract(new InputStreamReader(is), (Writer)null, in, new boolean[0]);
            this.json = null;
            this.xml = null;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RosettaData<T> load(String str) throws APIException {
        Parse<Reader, ?> in = this.df.getIn(this.inType);
        TimeTaken tt = in.start(this.trans);
        try {
            this.saved.extract(new StringReader(str), (Writer)null, in, new boolean[0]);
            switch (this.inType) {
                case XML: {
                    this.xml = str;
                    return this;
                }
                case JSON: {
                    this.json = str;
                    return this;
                }
            }
            return this;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    @Override
    public RosettaData<T> load(T t) throws APIException {
        Parse<Reader, ?> in = this.df.getIn(this.inType);
        TimeTaken tt = in.start(this.trans);
        try {
            if (this.df.marshal == null) {
                StringWriter sw = new StringWriter();
                this.df.jaxMar.marshal(this.trans.debug(), t, (Writer)sw, this.options);
                this.xml = sw.toString();
                this.saved.extract(new StringReader(this.xml), (Writer)null, this.df.inXML, new boolean[0]);
            } else {
                this.saved.extract(t, (Writer)null, this.df.marshal, new boolean[0]);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
        return this;
    }

    public Saved getEvents() {
        return this.saved;
    }

    @Override
    public T asObject() throws APIException {
        Out out = this.df.getOut(Data.TYPE.XML);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            StringWriter sw = new StringWriter();
            out.extract(null, sw, this.saved, new boolean[0]);
            Object o = this.df.jaxUmar.unmarshal(this.trans.debug(), sw.toString());
            return (T)o;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    @Override
    public String asString() throws APIException {
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            Object sw;
            if (this.outType == Data.TYPE.XML) {
                Object sw2;
                if (this.xml == null) {
                    sw2 = new StringWriter();
                    out.extract(null, (Writer)sw2, this.saved, this.options);
                    this.xml = ((StringWriter)sw2).toString();
                }
                sw2 = this.xml;
                return sw2;
            }
            if (this.json == null) {
                sw = new StringWriter();
                out.extract(null, (Writer)sw, this.saved, this.options);
                this.json = ((StringWriter)sw).toString();
            }
            sw = this.json;
            return sw;
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    @Override
    public RosettaData<T> to(OutputStream os) throws APIException, IOException {
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            if (this.outType == Data.TYPE.XML && this.xml != null) {
                os.write(this.xml.getBytes());
            } else if (this.outType == Data.TYPE.JSON && this.json != null) {
                os.write(this.json.getBytes());
            } else {
                out.extract(null, os, this.saved, this.options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
        return this;
    }

    @Override
    public RosettaData<T> to(Writer writer) throws APIException, IOException {
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            if (this.outType == Data.TYPE.XML && this.xml != null) {
                writer.append(this.xml);
            } else if (this.outType == Data.TYPE.JSON && this.json != null) {
                writer.append(this.json);
            } else {
                out.extract(null, writer, this.saved, this.options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
        return this;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.df.getTypeClass();
    }

    @Override
    public void direct(InputStream is, OutputStream os) throws APIException, IOException {
        this.direct(is, os, emptyOption);
    }

    public void direct(Reader reader, Writer writer, boolean ... options) throws APIException, IOException {
        Parse<Reader, ?> in = this.df.getIn(this.inType);
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            out.extract(reader, writer, in, options);
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    public void direct(T t, Writer writer, boolean ... options) throws APIException, IOException {
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            if (this.df.marshal == null) {
                StringWriter sw = new StringWriter();
                this.df.jaxMar.marshal(this.trans.debug(), t, (Writer)sw, options);
                this.xml = sw.toString();
                out.extract(new StringReader(this.xml), writer, this.df.inXML, options);
            } else {
                out.extract(t, writer, this.df.marshal, options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    public void direct(T t, OutputStream os, boolean ... options) throws APIException, IOException {
        Out out = this.df.getOut(this.outType);
        TimeTaken tt = this.trans.start(out.logName(), this.df.logType(this.outType));
        try {
            if (this.df.marshal == null) {
                if (this.outType.equals((Object)Data.TYPE.XML)) {
                    this.df.jaxMar.marshal(this.trans.debug(), t, os, options);
                } else {
                    StringWriter sw = new StringWriter();
                    this.df.jaxMar.marshal(this.trans.debug(), t, (Writer)sw, options);
                    this.xml = sw.toString();
                    out.extract(new StringReader(this.xml), new OutputStreamWriter(os), this.df.inXML, options);
                }
            } else {
                out.extract(t, new OutputStreamWriter(os), this.df.marshal, options);
            }
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        finally {
            tt.done();
        }
    }

    public void direct(InputStream is, OutputStream os, boolean ... options) throws APIException, IOException {
        this.direct(new InputStreamReader(is), (Writer)new OutputStreamWriter(os), options);
    }

    @Override
    public RosettaData<T> option(int option) {
        this.options[0] = (option & 0x100000) == 0x100000;
        this.options[1] = (option & 0x200000) == 0x200000;
        return this;
    }
}

