/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta.marshal;

import com.att.inno.env.util.Chrono;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DataWriter<T> {
    public static final DataWriter<String> STRING = new DataWriter<String>(){

        @Override
        public boolean write(String s, StringBuilder sb) {
            sb.append(s);
            return true;
        }
    };
    public static final DataWriter<Integer> INTEGER = new DataWriter<Integer>(){

        @Override
        public boolean write(Integer i, StringBuilder sb) {
            sb.append(i);
            return false;
        }
    };
    public static final DataWriter<Long> LONG = new DataWriter<Long>(){

        @Override
        public boolean write(Long t, StringBuilder sb) {
            sb.append(t);
            return false;
        }
    };
    public static final DataWriter<Byte> BYTE = new DataWriter<Byte>(){

        @Override
        public boolean write(Byte t, StringBuilder sb) {
            sb.append(t);
            return false;
        }
    };
    public static final DataWriter<Character> CHAR = new DataWriter<Character>(){

        @Override
        public boolean write(Character t, StringBuilder sb) {
            sb.append(t);
            return true;
        }
    };
    public static final DataWriter<Boolean> BOOL = new DataWriter<Boolean>(){

        @Override
        public boolean write(Boolean t, StringBuilder sb) {
            sb.append(t);
            return true;
        }
    };
    public static final DataWriter<XMLGregorianCalendar> DATE = new DataWriter<XMLGregorianCalendar>(){

        @Override
        public boolean write(XMLGregorianCalendar t, StringBuilder sb) {
            sb.append(Chrono.dateOnlyStamp(t));
            return true;
        }
    };
    public static final DataWriter<XMLGregorianCalendar> DATE_TIME = new DataWriter<XMLGregorianCalendar>(){

        @Override
        public boolean write(XMLGregorianCalendar t, StringBuilder sb) {
            sb.append(Chrono.dateTime(t));
            return true;
        }
    };
    private static final char[] chars = "0123456789ABCDEF".toCharArray();
    public static final DataWriter<byte[]> HEX_BINARY = new DataWriter<byte[]>(){

        @Override
        public boolean write(byte[] ba, StringBuilder sb) {
            for (int i = 0; i < ba.length; ++i) {
                byte b = ba[i];
                sb.append(chars[(b & 0xF0) >> 4]);
                sb.append(chars[b & 0xF]);
            }
            return true;
        }
    };

    public abstract boolean write(T var1, StringBuilder var2);
}

