/*
 * Decompiled with CFR 0.152.
 */
package com.att.rosetta.marshal;

import com.att.rosetta.Ladder;
import com.att.rosetta.Marshal;
import com.att.rosetta.ParseException;
import com.att.rosetta.Parsed;
import java.util.Iterator;

public abstract class ObjMarshal<T>
extends Marshal<T> {
    private Marshal<T>[] pml;
    private int end = 0;

    protected void add(Marshal<T> pm) {
        if (this.pml == null) {
            this.pml = new Marshal[8];
        } else if (this.end > this.pml.length) {
            Marshal<T>[] temp = this.pml;
            this.pml = new Marshal[this.pml.length + 8];
            System.arraycopy(temp, 0, this.pml, 0, this.pml.length);
        }
        this.pml[this.end] = pm;
        ++this.end;
    }

    @Override
    public Parsed<Marshal.State> parse(T in, Parsed<Marshal.State> parsed) throws ParseException {
        Ladder<Iterator<?>> ladder = ((Marshal.State)parsed.state).ladder;
        Iterator<?> iter = ladder.peek();
        if (iter == null) {
            if (this.pml.length > 0) {
                ladder.push(new FieldsIterator());
                parsed.event = (char)123;
            } else {
                ladder.push(DONE_ITERATOR);
            }
        } else if (!DONE_ITERATOR.equals(iter)) {
            Marshal marshal;
            FieldsIterator fields = (FieldsIterator)iter;
            ladder.ascend();
            Iterator<?> currFieldIter = ladder.peek();
            if (currFieldIter == null) {
                marshal = fields.next();
            } else if (!DONE_ITERATOR.equals(currFieldIter)) {
                marshal = fields.peek();
                if (marshal == null && fields.hasNext()) {
                    marshal = fields.next();
                }
            } else if (fields.hasNext()) {
                marshal = fields.next();
                ladder.push(null);
            } else {
                marshal = null;
            }
            if (marshal != null) {
                parsed = marshal.parse(in, parsed);
            }
            ladder.descend();
            if (marshal == null || parsed.event == '\u0000') {
                parsed.event = (char)125;
                ladder.push(DONE_ITERATOR);
            }
        }
        return parsed;
    }

    private class FieldsIterator
    implements Iterator<Marshal<T>> {
        private int idx = -1;

        private FieldsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ObjMarshal.this.end;
        }

        @Override
        public Marshal<T> next() {
            return ObjMarshal.this.pml[++this.idx];
        }

        public Marshal<T> peek() {
            return this.idx < 0 ? null : ObjMarshal.this.pml[this.idx];
        }

        @Override
        public void remove() {
            ((ObjMarshal)ObjMarshal.this).pml[this.idx] = null;
        }
    }
}

