/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf.test;

import com.att.cadi.AbsUserCache;
import com.att.cadi.Access;
import com.att.cadi.aaf.v2_0.AAFAuthn;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.aaf.v2_0.AAFLurPerm;
import com.att.cadi.aaf.v2_0.AAFTaf;
import com.att.cadi.lur.aaf.test.TestAccess;
import com.att.cadi.principal.CachedBasicPrincipal;
import com.att.cadi.taf.HttpTaf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JU_JMeter {
    private static AAFCon aaf;
    private static AAFAuthn aafAuthn;
    private static AAFLurPerm aafLur;
    private static ArrayList<Principal> perfIDs;
    private static AAFTaf aafTaf;
    private static int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void before() throws Exception {
        if (aafLur == null) {
            Properties props = System.getProperties();
            props.setProperty("AFT_LATITUDE", "32.780140");
            props.setProperty("AFT_LONGITUDE", "-96.800451");
            props.setProperty("DME2_EP_REGISTRY_CLASS", "DME2FS");
            props.setProperty("AFT_DME2_EP_REGISTRY_FS_DIR", "/Volumes/Data/src/authz/dme2reg");
            props.setProperty("AFT_ENVIRONMENT", "AFTUAT");
            props.setProperty("SCLD_PLATFORM", "NON-PROD");
            props.setProperty("aaf_url", "https://DME2RESOLVE/service=com.att.authz.AuthorizationService/version=2.0/envContext=DEV/routeOffer=BAU_SE");
            props.setProperty("aaf_timeout", "2000");
            int timeToLive = 3000;
            props.setProperty("aaf_clean_interval", Integer.toString(timeToLive));
            props.setProperty("aaf_high_count", "4");
            String aafPerfIDs = props.getProperty("AAF_PERF_IDS");
            perfIDs = new ArrayList();
            File perfFile = null;
            if (aafPerfIDs != null) {
                perfFile = new File(aafPerfIDs);
            }
            aaf = new AAFCon((Access)new TestAccess(System.out));
            aafTaf = new AAFTaf(aaf, false);
            aafLur = new AAFLurPerm(aaf, (AbsUserCache)aafTaf);
            aafAuthn = new AAFAuthn(aaf, (AbsUserCache)aafLur);
            aaf.basicAuth("testid@aaf.att.com", "whatever");
            if (perfFile == null || !perfFile.exists()) {
                perfIDs.add((Principal)new CachedBasicPrincipal((HttpTaf)aafTaf, "Basic dGVzdGlkOndoYXRldmVy", "aaf.att.com", (long)timeToLive));
                perfIDs.add(new Princ("jg1555@aaf.att.com"));
            } else {
                BufferedReader ir = new BufferedReader(new FileReader(perfFile));
                try {
                    String line;
                    while ((line = ir.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        perfIDs.add(new Princ(line));
                    }
                }
                finally {
                    ir.close();
                }
            }
            Assert.assertNotNull((Object)aafLur);
        }
    }

    private synchronized Principal getIndex() {
        if (perfIDs.size() <= ++index) {
            index = 0;
        }
        return perfIDs.get(index);
    }

    @Test
    public void test() {
        try {
            aafAuthn.validate("testid@aaf.att.com", "whatever");
            ArrayList perms = new ArrayList();
            aafLur.fishAll(this.getIndex(), perms);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            Assert.assertFalse((String)sw.toString(), (boolean)true);
        }
    }

    static {
        index = -1;
    }

    private static class Princ
    implements Principal {
        private String name;

        public Princ(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

