/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf.test;

import com.att.cadi.Access;
import com.att.cadi.CadiException;
import com.att.cadi.Lur;
import com.att.cadi.Permission;
import com.att.cadi.lur.ConfigPrincipal;
import com.att.cadi.lur.LocalPermission;
import com.att.cadi.lur.aaf.AAFLurPerm1_0;
import com.att.cadi.lur.aaf.AAFLurRole1_0;
import com.att.cadi.lur.aaf.test.TestAccess;
import java.security.Principal;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JU_Lur1_0Call {
    private static TestAccess ta;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ta = new TestAccess(System.out);
    }

    @Test
    public void test() throws CadiException {
        AAFLurPerm1_0 aafLur = new AAFLurPerm1_0((Access)ta, "http://DME2RESOLVE/service=com.att.authz.AuthorizationService/version=1.0.0/envContext=UAT/routeOffer=BAU_SE", "m12345", "m12345pass", 50000, 50000L, 200);
        ConfigPrincipal pri = new ConfigPrincipal("jg1555", "");
        ArrayList perms = new ArrayList();
        aafLur.fishAll((Principal)pri, perms);
        for (Permission p : perms) {
            System.out.println(p);
        }
        for (int i = 0; i < 10; ++i) {
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("component|svn:svnclient|*"), true);
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("com.att.cadi.service|kumquat|write"), false);
        }
        this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("bogus"), false);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("All Done");
    }

    public void testRole() throws CadiException {
        int i;
        TestAccess ta = new TestAccess(System.out);
        AAFLurRole1_0 aafLur = new AAFLurRole1_0((Access)ta, "http://DME2RESOLVE/service=com.att.authz.AuthorizationService/version=1.0.0/envContext=UAT/routeOffer=BAU_SE", "m12345", "m12345pass", 50000, 5000L, 200);
        ConfigPrincipal pri = new ConfigPrincipal("jg1555", "");
        for (i = 0; i < 10; ++i) {
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("com.att.cadi"), true);
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("global"), true);
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("kumquat"), false);
        }
        this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("bogus"), false);
        for (i = 0; i < 10; ++i) {
            this.print((Lur)aafLur, (Principal)pri, (Permission)new LocalPermission("supergroup"), false);
        }
        System.out.println("All Done");
    }

    private void print(Lur aafLur, Principal pri, Permission perm, boolean shouldBe) throws CadiException {
        long start = System.nanoTime();
        boolean ok = aafLur.fish(pri, perm);
        Assert.assertEquals((Object)shouldBe, (Object)ok);
        float ms = (float)(System.nanoTime() - start) / 1000000.0f;
        if (ok) {
            System.out.println("Yes, part of " + perm.getKey() + " (" + ms + "ms)");
        } else {
            System.out.println("No, not part of " + perm.getKey() + " (" + ms + "ms)");
        }
    }
}

