/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf.test;

import com.att.cadi.Access;
import com.att.cadi.Symm;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class TestAccess
implements Access {
    private Symm symm;
    private PrintStream out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestAccess(PrintStream out) {
        this.out = out;
        InputStream is = ClassLoader.getSystemResourceAsStream("cadi.properties");
        try {
            System.getProperties().load(is);
        }
        catch (IOException e) {
            e.printStackTrace(out);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace(out);
            }
        }
        String propfiles = System.getProperty("cadi_keyfile");
        if (propfiles == null) {
            System.err.println("No cadi_keyfile in Classpath");
        } else {
            try {
                is = new FileInputStream(propfiles);
                try {
                    this.symm = Symm.obtain((InputStream)is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(out);
            }
        }
    }

    public void log(Access.Level level, Object ... elements) {
        boolean first = true;
        for (int i = 0; i < elements.length; ++i) {
            if (first) {
                first = false;
            } else {
                this.out.print(' ');
            }
            this.out.print(elements[i].toString());
        }
        this.out.println();
    }

    public void log(Exception e, Object ... elements) {
        e.printStackTrace(this.out);
        this.log(Access.Level.ERROR, elements);
    }

    public void setLogLevel(Access.Level level) {
    }

    public ClassLoader classLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public String getProperty(String string, String def) {
        String rv = System.getProperty(string);
        return rv == null ? def : rv;
    }

    public void load(InputStream is) throws IOException {
    }

    public String decrypt(String encrypted, boolean anytext) throws IOException {
        return encrypted != null && (anytext || encrypted.startsWith("enc:")) ? this.symm.depass(encrypted) : encrypted;
    }
}

