/*
 * Decompiled with CFR 0.152.
 */
package com.att.aaf.client;

import aaf.v2_0.Approval;
import aaf.v2_0.Approvals;
import aaf.v2_0.CredRequest;
import aaf.v2_0.Error;
import aaf.v2_0.Keys;
import aaf.v2_0.NsRequest;
import aaf.v2_0.Nss;
import aaf.v2_0.Perm;
import aaf.v2_0.PermKey;
import aaf.v2_0.PermRequest;
import aaf.v2_0.Perms;
import aaf.v2_0.Pkey;
import aaf.v2_0.Request;
import aaf.v2_0.Role;
import aaf.v2_0.RoleKey;
import aaf.v2_0.RolePermRequest;
import aaf.v2_0.RoleRequest;
import aaf.v2_0.Roles;
import aaf.v2_0.UserRole;
import aaf.v2_0.UserRoleRequest;
import aaf.v2_0.UserRoles;
import aaf.v2_0.Users;
import com.att.inno.env.APIException;
import com.att.inno.env.Data;
import com.att.inno.env.util.Chrono;
import com.att.rosetta.env.RosettaDF;
import com.att.rosetta.env.RosettaEnv;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.GregorianCalendar;

public class Examples {
    public static <C> String print(RosettaEnv env, String nameOrContentType, boolean optional) throws APIException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method meth;
        Class<?> cls;
        String className = null;
        String version = null;
        Data.TYPE type = Data.TYPE.JSON;
        if (nameOrContentType.startsWith("application/")) {
            for (String ct : nameOrContentType.split("\\s*,\\s*")) {
                for (String elem : ct.split("\\s*;\\s*")) {
                    if (elem.endsWith("+json")) {
                        type = Data.TYPE.JSON;
                        className = elem.substring(elem.indexOf(47) + 1, elem.length() - 5);
                        continue;
                    }
                    if (elem.endsWith("+xml")) {
                        type = Data.TYPE.XML;
                        className = elem.substring(elem.indexOf(47) + 1, elem.length() - 4);
                        continue;
                    }
                    if (!elem.startsWith("version=")) continue;
                    version = elem.substring(8);
                }
                if (className != null && version != null) break;
            }
            if (className == null) {
                throw new APIException(nameOrContentType + " does not contain Class Information");
            }
        } else {
            className = nameOrContentType;
        }
        if ("Void".equals(className)) {
            return "";
        }
        version = "1.1".equals(version) ? "v1_0" : (version != null ? "v" + version.replace('.', '_') : "v2_0");
        try {
            cls = Examples.class.getClassLoader().loadClass("aaf." + version + '.' + className);
        }
        catch (ClassNotFoundException e) {
            throw new APIException((Throwable)e);
        }
        try {
            meth = Examples.class.getDeclaredMethod("new" + cls.getSimpleName() + version, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new APIException("ERROR: " + cls.getName() + " does not have an Example in Code.  Request from AAF Developers");
        }
        RosettaDF df = env.newDataFactory(new Class[]{cls});
        df.option(0x100000);
        Object data = meth.invoke(null, optional);
        String rv = df.newData().load(data).out(type).asString();
        return rv;
    }

    private static void setOptional(Request req) {
        GregorianCalendar gc = new GregorianCalendar();
        req.setStart(Chrono.timeStamp((GregorianCalendar)gc));
        gc.add(2, 6);
        req.setEnd(Chrono.timeStamp((GregorianCalendar)gc));
    }

    private static Request newRequestv2_0(boolean optional) {
        Request r = new Request();
        Examples.setOptional(r);
        return r;
    }

    private static RolePermRequest newRolePermRequestv2_0(boolean optional) {
        RolePermRequest rpr = new RolePermRequest();
        Pkey pkey = new Pkey();
        pkey.setType("com.att.myns.mytype");
        pkey.setInstance("myInstance");
        pkey.setAction("myAction");
        rpr.setPerm(pkey);
        rpr.setRole("com.att.myns.myrole");
        if (optional) {
            Examples.setOptional((Request)rpr);
        }
        return rpr;
    }

    private static Roles newRolesv2_0(boolean optional) {
        Roles rs = new Roles();
        Role r = new Role();
        rs.getRole().add(r);
        r.setName("com.att.myns.myRole");
        Pkey p = new Pkey();
        r.getPerms().add(p);
        p.setType("com.att.myns.myType");
        p.setInstance("myInstance");
        p.setAction("myAction");
        p = new Pkey();
        r.getPerms().add(p);
        p.setType("com.att.myns.myType");
        p.setInstance("myInstance");
        p.setAction("myOtherAction");
        r = new Role();
        rs.getRole().add(r);
        r.setName("com.att.myns.myOtherRole");
        p = new Pkey();
        r.getPerms().add(p);
        p.setType("com.att.myns.myOtherType");
        p.setInstance("myInstance");
        p.setAction("myAction");
        p = new Pkey();
        r.getPerms().add(p);
        p.setType("com.att.myns.myOthertype");
        p.setInstance("myInstance");
        p.setAction("myOtherAction");
        return rs;
    }

    private static PermRequest newPermRequestv2_0(boolean optional) {
        PermRequest pr = new PermRequest();
        pr.setType("com.att.myns.myType");
        pr.setInstance("myInstance");
        pr.setAction("myAction");
        if (optional) {
            pr.setDescription("Short and meaningful verbiage about the Permission");
            Examples.setOptional((Request)pr);
        }
        return pr;
    }

    private static Perm newPermv2_0(boolean optional) {
        Perm pr = new Perm();
        pr.setType("com.att.myns.myType");
        pr.setInstance("myInstance");
        pr.setAction("myAction");
        pr.getRoles().add("com.att.aaf.myRole");
        pr.getRoles().add("com.att.aaf.myRole2");
        pr.setDescription("This is my description, and I'm sticking with it");
        if (optional) {
            pr.setDescription("Short and meaningful verbiage about the Permission");
        }
        return pr;
    }

    private static PermKey newPermKeyv2_0(boolean optional) {
        PermKey pr = new PermKey();
        pr.setType("com.att.myns.myType");
        pr.setInstance("myInstance");
        pr.setAction("myAction");
        return pr;
    }

    private static Perms newPermsv2_0(boolean optional) {
        Perms perms = new Perms();
        Perm p = new Perm();
        perms.getPerm().add(p);
        p.setType("com.att.myns.myType");
        p.setInstance("myInstance");
        p.setAction("myAction");
        p.getRoles().add("com.att.myns.myRole");
        p.getRoles().add("com.att.myns.myRole2");
        p = new Perm();
        perms.getPerm().add(p);
        p.setType("com.att.myns.myOtherType");
        p.setInstance("myInstance");
        p.setAction("myOtherAction");
        p.getRoles().add("com.att.myns.myRole");
        p.getRoles().add("com.att.myns.myRole2");
        return perms;
    }

    private static UserRoleRequest newUserRoleRequestv2_0(boolean optional) {
        UserRoleRequest urr = new UserRoleRequest();
        urr.setRole("com.att.myns.myRole");
        urr.setUser("ab1234@csp.att.com");
        if (optional) {
            Examples.setOptional((Request)urr);
        }
        return urr;
    }

    private static NsRequest newNsRequestv2_0(boolean optional) {
        NsRequest nr = new NsRequest();
        nr.setName("com.att.myns");
        nr.getResponsible().add("ab1234@csp.att.com");
        nr.getResponsible().add("cd5678@csp.att.com");
        nr.getAdmin().add("zy9876@csp.att.com");
        nr.getAdmin().add("xw5432@csp.att.com");
        if (optional) {
            nr.setDescription("This is my Namespace to set up");
            nr.setType("APP");
            Examples.setOptional((Request)nr);
        }
        return nr;
    }

    private static Nss newNssv2_0(boolean optional) {
        Nss nss = new Nss();
        Nss.Ns ns = new Nss.Ns();
        nss.getNs().add(ns);
        ns.setName("com.att.myns");
        ns.getResponsible().add("ab1234@csp.att.com");
        ns.getResponsible().add("cd5678@csp.att.com");
        ns.getAdmin().add("zy9876@csp.att.com");
        ns.getAdmin().add("xw5432@csp.att.com");
        ns.setDescription("This is my Namespace to set up");
        ns = new Nss.Ns();
        nss.getNs().add(ns);
        ns.setName("com.att.myOtherNs");
        ns.getResponsible().add("ab1234@csp.att.com");
        ns.getResponsible().add("cd5678@csp.att.com");
        ns.getAdmin().add("zy9876@csp.att.com");
        ns.getAdmin().add("xw5432@csp.att.com");
        return nss;
    }

    private static RoleRequest newRoleRequestv2_0(boolean optional) {
        RoleRequest rr = new RoleRequest();
        rr.setName("com.att.myns.myRole");
        if (optional) {
            rr.setDescription("This is my Role");
            Examples.setOptional((Request)rr);
        }
        return rr;
    }

    private static CredRequest newCredRequestv2_0(boolean optional) {
        CredRequest cr = new CredRequest();
        cr.setId("myID@fully.qualified.domain");
        if (optional) {
            cr.setType(Integer.valueOf(2));
            cr.setEntry("0x125AB256344CE");
        } else {
            cr.setPassword("This is my provisioned password");
        }
        return cr;
    }

    private static Users newUsersv2_0(boolean optional) {
        Users users = new Users();
        Users.User user = new Users.User();
        users.getUser().add(user);
        user.setId("ab1234@csp.att.com");
        GregorianCalendar gc = new GregorianCalendar();
        user.setExpires(Chrono.timeStamp((GregorianCalendar)gc));
        user = new Users.User();
        users.getUser().add(user);
        user.setId("zy9876@csp.att.com");
        user.setExpires(Chrono.timeStamp((GregorianCalendar)gc));
        return users;
    }

    private static Role newRolev2_0(boolean optional) {
        Role r = new Role();
        r.setName("com.att.myns.myRole");
        Pkey p = new Pkey();
        r.getPerms().add(p);
        p.setType("com.att.myns.myType");
        p.setInstance("myInstance");
        p.setAction("myAction");
        return r;
    }

    private static RoleKey newRoleKeyv2_0(boolean optional) {
        RoleKey r = new RoleKey();
        r.setName("com.att.myns.myRole");
        return r;
    }

    private static Keys newKeysv2_0(boolean optional) {
        Keys ks = new Keys();
        ks.getKey().add("Reponse 1");
        ks.getKey().add("Response 2");
        return ks;
    }

    private static UserRoles newUserRolesv2_0(boolean optional) {
        UserRoles urs = new UserRoles();
        UserRole ur = new UserRole();
        ur.setUser("xy1234");
        ur.setRole("com.test.myapp.myRole");
        ur.setExpires(Chrono.timeStamp());
        urs.getUserRole().add(ur);
        ur = new UserRole();
        ur.setUser("yx4321");
        ur.setRole("com.test.yourapp.yourRole");
        ur.setExpires(Chrono.timeStamp());
        urs.getUserRole().add(ur);
        return urs;
    }

    private static Approvals newApprovalsv2_0(boolean optional) {
        Approvals as = new Approvals();
        Approval a = new Approval();
        a.setApprover("MyApprover");
        a.setId("MyID");
        a.setMemo("My memo (and then some)");
        a.setOperation("MyOperation");
        a.setStatus("MyStatus");
        a.setTicket("MyTicket");
        a.setType("MyType");
        a.setUpdated(Chrono.timeStamp());
        a.setUser("MyUser");
        as.getApprovals().add(a);
        a = new Approval();
        a.setApprover("MyApprover2");
        a.setId("MyID2");
        a.setMemo("My memo (and then some)2");
        a.setOperation("MyOperation2");
        a.setStatus("MyStatus2");
        a.setTicket("MyTicket2");
        a.setType("MyType2");
        a.setUpdated(Chrono.timeStamp());
        a.setUser("MyUser2");
        as.getApprovals().add(a);
        return as;
    }

    private static Approval newApprovalv2_0(boolean optional) {
        Approval a = new Approval();
        a.setApprover("MyApprover");
        a.setId("MyID");
        a.setMemo("My memo (and then some)");
        a.setOperation("MyOperation");
        a.setStatus("MyStatus");
        a.setTicket("MyTicket");
        a.setType("MyType");
        a.setUpdated(Chrono.timeStamp());
        a.setUser("MyUser");
        return a;
    }

    private static Error newErrorv2_0(boolean optional) {
        Error err = new Error();
        err.setMessageId("SVC1403");
        err.setText("MyText %s, %s: The last three digits are usually the HTTP Code");
        err.getVariables().add("Variable 1");
        err.getVariables().add("Variable 2");
        return err;
    }
}

