/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.v2_0;

import aaf.v2_0.Perm;
import aaf.v2_0.Perms;
import com.att.aft.dme2.api.DME2Exception;
import com.att.cadi.AbsUserCache;
import com.att.cadi.Access;
import com.att.cadi.CachedPrincipal;
import com.att.cadi.Permission;
import com.att.cadi.User;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.aaf.v2_0.AbsAAFLur;
import com.att.cadi.client.Future;
import com.att.cadi.lur.aaf.AAFPermission;
import com.att.inno.env.APIException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Map;

public class AAFLurPerm
extends AbsAAFLur<AAFPermission> {
    public AAFLurPerm(AAFCon con) throws DME2Exception, URISyntaxException, APIException {
        super(con);
    }

    public AAFLurPerm(AAFCon con, AbsUserCache<AAFPermission> auc) throws DME2Exception, URISyntaxException, APIException {
        super(con, auc);
    }

    @Override
    protected User<AAFPermission> loadUser(Principal p) {
        Principal principal = (Principal)transmutate.mutate(p);
        if (principal == null) {
            return null;
        }
        return this.loadUser(p, p.getName());
    }

    @Override
    protected User<AAFPermission> loadUser(String name) {
        return this.loadUser(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User<AAFPermission> loadUser(Principal p, final String name) {
        User code2;
        long start = System.nanoTime();
        boolean success = false;
        try {
            Future fp = this.aaf.client.read("/authz/perms/user/" + name, this.aaf.permsDF, new String[0]);
            User user = this.getUser(name);
            if (p == null) {
                p = new Principal(){
                    private String n;
                    {
                        this.n = name;
                    }

                    @Override
                    public String getName() {
                        return this.n;
                    }
                };
            }
            if (user == null) {
                user = new User(p, (long)this.aaf.userExpires);
                this.addUser(user);
            }
            if (fp.get(this.aaf.timeout)) {
                success = true;
                Map newMap = user.newMap();
                for (Perm perm : ((Perms)fp.value).getPerm()) {
                    user.add(newMap, (Permission)new AAFPermission(perm.getType(), perm.getInstance(), perm.getAction()));
                    this.aaf.access.log(Access.Level.DEBUG, new Object[]{name, "has '", perm.getType(), Character.valueOf('|'), perm.getInstance(), Character.valueOf('|'), perm.getAction(), Character.valueOf('\'')});
                }
                user.setMap(newMap);
                user.renewPerm();
            } else {
                int code2 = fp.code();
                switch (code2) {
                    case 401: {
                        this.aaf.access.log(Access.Level.ERROR, new Object[]{code2, "Unauthorized to make AAF calls"});
                        break;
                    }
                    default: {
                        this.aaf.access.log(Access.Level.ERROR, new Object[]{code2, fp.body()});
                    }
                }
            }
            code2 = user;
        }
        catch (Exception e) {
            User<AAFPermission> user;
            try {
                this.aaf.access.log(e, new Object[]{"Calling", "/authz/perms/user/" + name});
                user = null;
            }
            catch (Throwable throwable) {
                float time = (float)(System.nanoTime() - start) / 1000000.0f;
                this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Loaded" : "Load Failure", name, "from AAF in", Float.valueOf(time), "ms"});
                throw throwable;
            }
            float time = (float)(System.nanoTime() - start) / 1000000.0f;
            this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Loaded" : "Load Failure", name, "from AAF in", Float.valueOf(time), "ms"});
            return user;
        }
        float time = (float)(System.nanoTime() - start) / 1000000.0f;
        this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Loaded" : "Load Failure", name, "from AAF in", Float.valueOf(time), "ms"});
        return code2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPrincipal.Resp reload(User<AAFPermission> user) {
        CachedPrincipal.Resp resp;
        Future fp;
        boolean success;
        long start;
        String name;
        block9: {
            name = user.principal.getName();
            start = System.nanoTime();
            success = false;
            fp = this.aaf.client.read("/authz/perms/user/" + name, this.aaf.permsDF, new String[0]);
            if (!fp.get(this.aaf.timeout)) break block9;
            success = true;
            Map newMap = user.newMap();
            for (Perm perm : ((Perms)fp.value).getPerm()) {
                user.add(newMap, (Permission)new AAFPermission(perm.getType(), perm.getInstance(), perm.getAction()));
                this.aaf.access.log(Access.Level.DEBUG, new Object[]{name, "has", perm.getType(), perm.getInstance(), perm.getAction()});
            }
            user.renewPerm();
            CachedPrincipal.Resp resp2 = CachedPrincipal.Resp.REVALIDATED;
            float time = (float)(System.nanoTime() - start) / 1000000.0f;
            this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Reloaded" : "Reload Failure", name, "from AAF in", Float.valueOf(time), "ms"});
            return resp2;
        }
        try {
            int code = fp.code();
            switch (code) {
                case 401: {
                    this.aaf.access.log(Access.Level.ERROR, new Object[]{code, "Unauthorized to make AAF calls"});
                    break;
                }
                default: {
                    this.aaf.access.log(Access.Level.ERROR, new Object[]{code, fp.body()});
                }
            }
            resp = CachedPrincipal.Resp.UNVALIDATED;
        }
        catch (Exception e) {
            CachedPrincipal.Resp resp3;
            try {
                this.aaf.access.log(e, new Object[]{"Calling", "/authz/perms/user/" + name});
                resp3 = CachedPrincipal.Resp.INACCESSIBLE;
            }
            catch (Throwable throwable) {
                float time = (float)(System.nanoTime() - start) / 1000000.0f;
                this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Reloaded" : "Reload Failure", name, "from AAF in", Float.valueOf(time), "ms"});
                throw throwable;
            }
            float time = (float)(System.nanoTime() - start) / 1000000.0f;
            this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Reloaded" : "Reload Failure", name, "from AAF in", Float.valueOf(time), "ms"});
            return resp3;
        }
        float time = (float)(System.nanoTime() - start) / 1000000.0f;
        this.aaf.access.log(Access.Level.AUDIT, new Object[]{success ? "Reloaded" : "Reload Failure", name, "from AAF in", Float.valueOf(time), "ms"});
        return resp;
    }

    @Override
    protected boolean isCorrectPermType(Permission pond) {
        return pond instanceof AAFPermission;
    }
}

