/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.v2_0;

import com.att.cadi.AbsUserCache;
import com.att.cadi.Access;
import com.att.cadi.CachedPrincipal;
import com.att.cadi.GetCred;
import com.att.cadi.Hash;
import com.att.cadi.SecuritySetter;
import com.att.cadi.Taf;
import com.att.cadi.User;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.aaf.v2_0.DMEPrincipalSS;
import com.att.cadi.client.Future;
import com.att.cadi.client.Rcli;
import com.att.cadi.lur.aaf.AAFPermission;
import com.att.cadi.principal.BasicPrincipal;
import com.att.cadi.principal.CachedBasicPrincipal;
import com.att.cadi.taf.HttpTaf;
import com.att.cadi.taf.TafResp;
import com.att.cadi.taf.basic.BasicHttpTafResp;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AAFTaf
extends AbsUserCache<AAFPermission>
implements HttpTaf {
    private AAFCon aaf;
    private boolean warn;

    public AAFTaf(AAFCon con, boolean turnOnWarning) {
        super(con.access, (long)con.cleanInterval, con.highCount, con.usageRefreshTriggerCount);
        this.aaf = con;
        this.warn = turnOnWarning;
    }

    public AAFTaf(AAFCon con, boolean turnOnWarning, AbsUserCache<AAFPermission> other) {
        super(other);
        this.aaf = con;
        this.warn = turnOnWarning;
    }

    public TafResp validate(Taf.LifeForm reading, HttpServletRequest req, HttpServletResponse resp) {
        String auth = req.getHeader("Authorization");
        if (auth == null) {
            return new BasicHttpTafResp(this.aaf.access, null, "Requesting HTTP Basic Authorization", TafResp.RESP.TRY_AUTHENTICATING, resp, this.aaf.getRealm(), false);
        }
        if (this.warn && !req.isSecure()) {
            this.aaf.access.log(Access.Level.WARN, new Object[]{"WARNING! BasicAuth has been used over an insecure channel"});
        }
        try {
            CachedBasicPrincipal bp = new CachedBasicPrincipal((HttpTaf)this, auth, this.aaf.getRealm(), (long)this.aaf.cleanInterval);
            User usr = this.getUser((Principal)bp);
            if (usr != null && usr.principal != null && usr.principal instanceof GetCred && Hash.isEqual((byte[])bp.getCred(), (byte[])((GetCred)usr.principal).getCred())) {
                return new BasicHttpTafResp(this.aaf.access, (Principal)bp, bp.getName() + " authenticated by cached AAF password", TafResp.RESP.IS_AUTHENTICATED, resp, this.aaf.getRealm(), false);
            }
            AbsUserCache.Miss miss = this.missed(bp.getName());
            if (miss != null && !miss.mayContinue(bp.getCred())) {
                return new BasicHttpTafResp(this.aaf.access, null, this.buildMsg((Principal)bp, req, "User/Pass Retry limit exceeded"), TafResp.RESP.FAIL, resp, this.aaf.getRealm(), true);
            }
            Rcli userAAF = this.aaf.client.forUser((SecuritySetter)new DMEPrincipalSS((Principal)bp));
            Future fp = userAAF.read("/authn/basicAuth", "text/plain", new String[0]);
            if (fp.get(this.aaf.timeout)) {
                if (usr != null) {
                    usr.principal = bp;
                } else {
                    this.addUser(new User((Principal)bp, (long)this.aaf.cleanInterval));
                }
                return new BasicHttpTafResp(this.aaf.access, (Principal)bp, bp.getName() + " authenticated by AAF password", TafResp.RESP.IS_AUTHENTICATED, resp, this.aaf.getRealm(), false);
            }
            boolean rv = this.addMiss(bp.getName(), bp.getCred());
            if (rv) {
                return new BasicHttpTafResp(this.aaf.access, null, this.buildMsg((Principal)bp, req, "User/Pass combo invalid via AAF"), TafResp.RESP.TRY_AUTHENTICATING, resp, this.aaf.getRealm(), true);
            }
            return new BasicHttpTafResp(this.aaf.access, null, this.buildMsg((Principal)bp, req, "User/Pass combo invalid via AAF - Retry limit exceeded"), TafResp.RESP.FAIL, resp, this.aaf.getRealm(), true);
        }
        catch (IOException e) {
            String msg = this.buildMsg(null, req, "Invalid Auth Token");
            this.aaf.access.log(Access.Level.INFO, new Object[]{msg, Character.valueOf('('), e.getMessage(), Character.valueOf(')')});
            return new BasicHttpTafResp(this.aaf.access, null, msg, TafResp.RESP.TRY_AUTHENTICATING, resp, this.aaf.getRealm(), true);
        }
        catch (Exception e) {
            String msg = this.buildMsg(null, req, "Authenticating Service unavailable");
            this.aaf.access.log(Access.Level.INFO, new Object[]{msg, Character.valueOf('('), e.getMessage(), Character.valueOf(')')});
            return new BasicHttpTafResp(this.aaf.access, null, msg, TafResp.RESP.FAIL, resp, this.aaf.getRealm(), false);
        }
    }

    private String buildMsg(Principal pr, HttpServletRequest req, Object ... msg) {
        StringBuilder sb = new StringBuilder();
        for (Object s : msg) {
            sb.append(s.toString());
        }
        if (pr != null) {
            sb.append(" for ");
            sb.append(pr.getName());
        }
        sb.append(" from ");
        sb.append(req.getRemoteAddr());
        sb.append(':');
        sb.append(req.getRemotePort());
        return sb.toString();
    }

    public CachedPrincipal.Resp revalidate(CachedPrincipal prin) {
        if (prin instanceof BasicPrincipal) {
            Rcli userAAF = this.aaf.client.forUser((SecuritySetter)new DMEPrincipalSS((Principal)prin));
            try {
                Future fp = userAAF.read("/authn/basicAuth", "text/plain", new String[0]);
                return fp.get(this.aaf.timeout) ? CachedPrincipal.Resp.REVALIDATED : CachedPrincipal.Resp.UNVALIDATED;
            }
            catch (Exception e) {
                this.aaf.access.log(e, new Object[]{"Cannot Revalidate", prin.getName()});
                return CachedPrincipal.Resp.INACCESSIBLE;
            }
        }
        return CachedPrincipal.Resp.NOT_MINE;
    }
}

