/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.aaf.v2_0;

import com.att.aft.dme2.api.DME2Exception;
import com.att.cadi.AbsUserCache;
import com.att.cadi.Access;
import com.att.cadi.CachingLur;
import com.att.cadi.Permission;
import com.att.cadi.StrLur;
import com.att.cadi.Transmutate;
import com.att.cadi.User;
import com.att.cadi.aaf.v2_0.AAFCon;
import com.att.cadi.lur.aaf.AAFPermission;
import com.att.cadi.lur.aaf.AAFTransmutate;
import com.att.inno.env.APIException;
import com.att.inno.env.util.Split;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbsAAFLur<PERM extends Permission>
extends AbsUserCache<PERM>
implements StrLur,
CachingLur<PERM> {
    protected static final byte[] BLANK_PASSWORD = new byte[0];
    protected static final Transmutate<Principal> transmutate = new AAFTransmutate();
    private String[] debug = null;
    public AAFCon aaf;
    private String[] supports;

    public AbsAAFLur(AAFCon con) throws DME2Exception, URISyntaxException, APIException {
        super(con.access, (long)con.cleanInterval, con.highCount, con.usageRefreshTriggerCount);
        this.aaf = con;
        this.setLur(this);
        this.supports = con.access.getProperty("aaf_domain_support", ".com").split("\\s*:\\s*");
    }

    public AbsAAFLur(AAFCon con, AbsUserCache<PERM> auc) throws DME2Exception, URISyntaxException, APIException {
        super(auc);
        this.aaf = con;
        this.setLur(this);
        this.supports = con.access.getProperty("aaf_domain_support", ".com").split("\\s*:\\s*");
    }

    public void setDebug(String ids) {
        this.debug = ids == null ? null : Split.split((char)',', (String)ids);
    }

    protected abstract User<PERM> loadUser(Principal var1);

    protected abstract User<PERM> loadUser(String var1);

    public final boolean supports(String userName) {
        if (userName != null) {
            for (String s : this.supports) {
                if (!userName.endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isCorrectPermType(Permission var1);

    public boolean fish(Principal bait, Permission pond) {
        return this.fish(bait.getName(), pond);
    }

    public void fishAll(Principal bait, List<Permission> perms) {
        this.fishAll(bait.getName(), perms);
    }

    public boolean fish(String bait, Permission pond) {
        if (this.isDebug(bait)) {
            boolean rv = false;
            StringBuilder sb = new StringBuilder("Log for ");
            sb.append(bait);
            if (this.supports(bait)) {
                User<PERM> user = this.getUser(bait);
                if (user == null) {
                    sb.append("\n\tUser is not in Cache");
                } else {
                    if (user.noPerms()) {
                        sb.append("\n\tUser has no Perms");
                    }
                    if (user.permExpired()) {
                        sb.append("\n\tUser's perm expired [");
                        sb.append(new Date(user.permExpires()));
                        sb.append(']');
                    } else {
                        sb.append("\n\tUser's perm expires [");
                        sb.append(new Date(user.permExpires()));
                        sb.append(']');
                    }
                }
                if (user == null || user.noPerms() && user.permExpired()) {
                    user = this.loadUser(bait);
                    sb.append("\n\tloadUser called");
                }
                if (user == null) {
                    sb.append("\n\tUser was not Loaded");
                } else if (user.contains(pond)) {
                    sb.append("\n\tUser contains ");
                    sb.append(pond.getKey());
                    rv = true;
                } else {
                    sb.append("\n\tUser does not contain ");
                    sb.append(pond.getKey());
                    ArrayList perms = new ArrayList();
                    user.copyPermsTo(perms);
                    for (Permission p : perms) {
                        sb.append("\n\t\t");
                        sb.append(p.getKey());
                    }
                }
            } else {
                sb.append("AAF Lur does not support [");
                sb.append(bait);
                sb.append("]");
            }
            this.aaf.access.log(Access.Level.INFO, new Object[]{sb});
            return rv;
        }
        if (this.supports(bait)) {
            User<PERM> user = this.getUser(bait);
            if (user == null || user.noPerms() && user.permExpired()) {
                user = this.loadUser(bait);
            }
            return user == null ? false : user.contains(pond);
        }
        return false;
    }

    public void fishAll(String bait, List<Permission> perms) {
        if (this.isDebug(bait)) {
            StringBuilder sb = new StringBuilder("Log for ");
            sb.append(bait);
            if (this.supports(bait)) {
                User<PERM> user = this.getUser(bait);
                if (user == null) {
                    sb.append("\n\tUser is not in Cache");
                } else {
                    if (user.noPerms()) {
                        sb.append("\n\tUser has no Perms");
                    }
                    if (user.permExpired()) {
                        sb.append("\n\tUser's perm expired [");
                        sb.append(new Date(user.permExpires()));
                        sb.append(']');
                    } else {
                        sb.append("\n\tUser's perm expires [");
                        sb.append(new Date(user.permExpires()));
                        sb.append(']');
                    }
                }
                if (user == null || user.noPerms() && user.permExpired()) {
                    user = this.loadUser(bait);
                    sb.append("\n\tloadUser called");
                }
                if (user == null) {
                    sb.append("\n\tUser was not Loaded");
                } else {
                    sb.append("\n\tCopying Perms ");
                    user.copyPermsTo(perms);
                    for (Permission p : perms) {
                        sb.append("\n\t\t");
                        sb.append(p.getKey());
                    }
                }
            } else {
                sb.append("AAF Lur does not support [");
                sb.append(bait);
                sb.append("]");
            }
            this.aaf.access.log(Access.Level.INFO, new Object[]{sb});
        } else if (this.supports(bait)) {
            User<PERM> user = this.getUser(bait);
            if (user == null || user.noPerms() && user.permExpired()) {
                user = this.loadUser(bait);
            }
            if (user != null) {
                user.copyPermsTo(perms);
            }
        }
    }

    public void remove(String user) {
        super.remove(user);
    }

    private boolean isDebug(String bait) {
        if (this.debug != null) {
            if (this.debug.length == 1 && "all".equals(this.debug[0])) {
                return true;
            }
            for (String s : this.debug) {
                if (!s.equals(bait)) continue;
                return true;
            }
        }
        return false;
    }

    public <A> void fishOneOf(String bait, A obj, String type, String instance, List<Action<A>> actions) {
        User<PERM> user = this.getUser(bait);
        if (user == null || user.noPerms() && user.permExpired()) {
            user = this.loadUser(bait);
        }
        if (user != null) {
            ReuseAAFPermission perm = new ReuseAAFPermission(type, instance);
            for (Action<A> action : actions) {
                perm.setAction(action.getName());
                if (!user.contains((Permission)perm) || !action.exec(obj)) continue;
                return;
            }
        }
    }

    private class ReuseAAFPermission
    extends AAFPermission {
        public ReuseAAFPermission(String type, String instance) {
            super(type, instance, null);
        }

        public void setAction(String s) {
            this.action = s;
        }
    }

    public static interface Action<A> {
        public String getName();

        public boolean exec(A var1);
    }
}

