/*
 * Decompiled with CFR 0.152.
 */
package com.att.cadi.lur.aaf;

import aaf.xsd.Permissions;
import com.att.aft.dme2.api.DME2Client;
import com.att.cadi.Access;
import com.att.cadi.CadiException;
import com.att.cadi.Permission;
import com.att.cadi.User;
import com.att.cadi.lur.aaf.AAFPermission;
import com.att.cadi.lur.aaf.AAF_1_0_Permission;
import com.att.cadi.lur.aaf.AbsAAFLur;
import com.att.cadi.lur.aaf.JaxSetDocPermission;
import com.att.rosetta.JaxEval;
import com.att.rosetta.OutJax;
import com.att.rosetta.Parse;
import java.io.StringReader;
import java.io.Writer;
import java.security.Principal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AAFLurPerm1_0
extends AbsAAFLur<AAFPermission> {
    private Pattern att_mechID = Pattern.compile("[a-zA-Z][a-zA-Z0-9][0-9]{3}[a-zA-Z0-9]");

    public AAFLurPerm1_0(Access access, String dmeServiceName, String mechUser, String mechPasswd, int dmeTimeOut, long userExpiration, int highCount) throws CadiException {
        super(access, dmeServiceName, mechUser, mechPasswd, dmeTimeOut, userExpiration, highCount, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected User<AAFPermission> loadUser(Principal p) throws Exception {
        User user;
        Principal principal = (Principal)transmutate.mutate(p);
        if (principal == null) {
            return null;
        }
        String name = principal.getName();
        long start = System.nanoTime();
        DME2Client client = this.newClient();
        try {
            client.setPayload("/authz/users/" + name + "/permissions");
            String responseText = client.sendAndWait((long)this.dmeTimeout);
            JaxSetDocPermission jsd = new JaxSetDocPermission();
            new OutJax((JaxEval)jsd).extract((Object)new StringReader(responseText), (Writer)null, (Parse)inJSON, new boolean[0]);
            User user2 = this.getUser(p);
            if (user2 == null) {
                user2 = new User(p, this.userExpiration);
            }
            this.addUser(user2);
            Permissions perms = jsd.getPermissions();
            if (perms != null) {
                Map newMap = user2.newMap();
                for (aaf.xsd.Permission perm : perms.getPermissions()) {
                    user2.add(newMap, (Permission)new AAF_1_0_Permission(perm));
                }
                user2.setMap(newMap);
            }
            user = user2;
        }
        catch (Throwable throwable) {
            float time = (float)(System.nanoTime() - start) / 1000000.0f;
            this.access.log(Access.Level.AUDIT, new Object[]{"Remote AAF Service Lookup", name, "in", Float.valueOf(time), "ms"});
            throw throwable;
        }
        float time = (float)(System.nanoTime() - start) / 1000000.0f;
        this.access.log(Access.Level.AUDIT, new Object[]{"Remote AAF Service Lookup", name, "in", Float.valueOf(time), "ms"});
        return user;
    }

    @Override
    protected boolean isCorrectPermType(Permission pond) {
        return pond instanceof AAFPermission;
    }

    @Override
    public boolean supports(String userName) {
        if (userName == null) {
            return false;
        }
        Matcher m = this.att_mechID.matcher(userName);
        return m == null ? false : m.matches();
    }
}

