/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.heat.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.woorea.openstack.heat.model.Link;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="stack")
public class Stack {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="links")
    private List<Link> links;
    @JsonProperty(value="stack_status_reason")
    private String stackStatusReason;
    @JsonProperty(value="stack_name")
    private String stackName;
    @JsonProperty(value="updated_time")
    private Date updatedTime;
    @JsonProperty(value="creation_time")
    private Date creationTime;
    @JsonProperty(value="stack_status")
    private String stackStatus;
    @JsonProperty(value="id")
    private String id;
    @JsonIgnore
    private static ObjectMapper mapper = new ObjectMapper();
    private List<Output> outputs;
    @JsonProperty(value="parameters")
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getStackStatus() {
        return this.stackStatus;
    }

    public void setStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackStatusReason() {
        return this.stackStatusReason;
    }

    public void setStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Stack{description='" + this.description + '\'' + ", links=" + this.links + ", stackStatusReason='" + this.stackStatusReason + '\'' + ", stackName='" + this.stackName + '\'' + ", updatedTime=" + this.updatedTime + ", creationTime=" + this.creationTime + ", stackStatus='" + this.stackStatus + '\'' + ", id='" + this.id + '\'' + ", outputs='" + this.outputs + '\'' + ", parameters='" + this.parameters + '\'' + '}';
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    private Object _findOutputValue(String key) {
        for (Output o : this.outputs) {
            if (!o.getOutputKey().equals(key)) continue;
            return o.getOutputValue();
        }
        return null;
    }

    public String getOutputValue(String key) {
        Object value = this._findOutputValue(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public <T> T getOutputValue(String key, Class<T> type) {
        try {
            String s = mapper.writeValueAsString(this._findOutputValue(key));
            return (T)mapper.readValue(s, type);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
        for (Map.Entry<String, Object> param : this.parameters.entrySet()) {
            String value = param.getValue().toString();
            if (!value.startsWith("[") || !value.endsWith("]")) continue;
            param.setValue(value.substring(1, value.length() - 1).replaceAll("u'([^']+)'", "$1"));
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Output {
        @JsonProperty(value="output_value")
        private Object outputValue;
        private String description;
        @JsonProperty(value="output_key")
        private String outputKey;

        public Object getOutputValue() {
            return this.outputValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOutputKey() {
            return this.outputKey;
        }

        public String toString() {
            return "Output [key=" + this.outputKey + ", value=" + this.outputValue + "]";
        }
    }
}

