/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.connector;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.impl.ClientRequestImpl;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackClientConnector;
import com.woorea.openstack.base.client.OpenStackConnectException;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.base.client.OpenStackResponseException;
import com.woorea.openstack.common.client.JULWrapper;
import com.woorea.openstack.connector.JerseyResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;

public class JerseyConnector
implements OpenStackClientConnector {
    private static final int DEFAULT_PROXY_PORT = 8080;
    private Client client = null;
    private LoggingFilter filter = null;
    private Logger logger;
    private boolean proxyConnection = false;
    private String proxyHost;
    private int proxyPort;
    private List<Pattern> trustedHostPatterns = new ArrayList<Pattern>();

    /*
     * WARNING - void declaration
     */
    public <T> OpenStackResponse request(OpenStackRequest<T> request) throws OpenStackResponseException, OpenStackConnectException {
        try {
            this.connect(request);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new SecurityException(e.getMessage(), e);
        }
        WebResource target = this.client.resource(request.endpoint()).path(request.path());
        for (Map.Entry entry : request.queryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                target = target.queryParam((String)entry.getKey(), String.valueOf(o));
            }
        }
        target.addFilter((ClientFilter)this.filter);
        OutBoundHeaders headers = new OutBoundHeaders();
        for (Map.Entry entry : request.headers().entrySet()) {
            for (Object v : (List)entry.getValue()) {
                headers.add(entry.getKey(), v);
            }
        }
        if (request.entity() != null && request.entity().getContentType() != null) {
            headers.add((Object)"Content-Type", (Object)request.entity().getContentType());
        } else {
            headers.add((Object)"Content-Type", (Object)"application/json");
        }
        try {
            void var4_10;
            Object var4_7 = null;
            if (request.entity() != null && request.entity().getEntity() != null) {
                ClientResponse clientResponse = target.getHeadHandler().handle((ClientRequest)new ClientRequestImpl(target.getURI(), request.method().name(), request.entity().getEntity(), (MultivaluedMap)headers));
            } else {
                ClientResponse clientResponse = target.getHeadHandler().handle((ClientRequest)new ClientRequestImpl(target.getURI(), request.method().name(), null, (MultivaluedMap)headers));
            }
            return new JerseyResponse((ClientResponse)var4_10);
        }
        catch (ClientHandlerException clientHandlerException) {
            throw new OpenStackConnectException(clientHandlerException.getMessage(), (Throwable)clientHandlerException);
        }
        catch (UniformInterfaceException uniformInterfaceException) {
            throw new OpenStackResponseException(uniformInterfaceException.getResponse().getClientResponseStatus().getReasonPhrase(), uniformInterfaceException.getResponse().getStatus());
        }
    }

    private synchronized <T> void connect(OpenStackRequest<T> request) throws KeyManagementException, NoSuchAlgorithmException {
        if (this.client != null) {
            return;
        }
        OpenStackClient osClient = request.getOpenStackClient();
        Properties properties = osClient.getProperties();
        this.logger = osClient.getLogger();
        this.filter = new LoggingFilter((java.util.logging.Logger)new JULWrapper(this.logger));
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        String temp = properties.getProperty("com.woorea.openstack.trust.host.list");
        if (temp != null && temp.length() > 0) {
            String[] tokens;
            for (String token : tokens = temp.split(",")) {
                if (token == null || token.length() <= 0) continue;
                StringBuffer buffer = new StringBuffer(token);
                block8: for (int index = 0; index < buffer.length(); ++index) {
                    switch (buffer.charAt(index)) {
                        case '*': {
                            buffer.insert(index, ".");
                            ++index;
                            continue block8;
                        }
                        case '+': {
                            buffer.insert(index, ".");
                            ++index;
                            continue block8;
                        }
                        case '.': {
                            buffer.replace(index, index + 1, "\\.");
                            ++index;
                        }
                    }
                }
                this.trustedHostPatterns.add(Pattern.compile(buffer.toString()));
            }
        }
        this.proxyHost = properties.getProperty("http.proxyHost");
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            temp = properties.getProperty("http.proxyPort");
            if (temp != null) {
                temp = temp.trim();
            }
            if (temp == null || temp.length() == 0) {
                this.proxyPort = 8080;
                this.proxyConnection = true;
            } else {
                try {
                    this.proxyPort = Integer.valueOf(temp);
                }
                catch (NumberFormatException e) {
                    this.logger.error(String.format("Invalid port \"%s\" specified for proxy host \"%s\", a direct connection will be used", temp, this.proxyHost));
                }
                if (this.proxyPort > 0 && this.proxyPort < 65536) {
                    this.proxyConnection = true;
                } else {
                    this.logger.error(String.format("Invalid port \"%d\" specified for proxy host \"%s\", a direct connection will be used", this.proxyPort, this.proxyHost));
                }
            }
        }
        if (request.endpoint().startsWith("https") && !this.trustedHostPatterns.isEmpty()) {
            clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(this.getHostnameVerifier(), this.getSSLContext()));
        }
        clientConfig.getClasses().add(JacksonJaxbJsonProvider.class);
        clientConfig.getClasses().add(OpenStackObjectMapper.class);
        if (this.proxyConnection) {
            this.logger.debug(String.format("Connecting using proxy %s:%d", this.proxyHost, this.proxyPort));
            this.client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
                Proxy p = null;

                public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                    if (this.p == null) {
                        this.p = JerseyConnector.this.proxyHost != null && JerseyConnector.this.proxyPort != 0 ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(JerseyConnector.this.proxyHost, JerseyConnector.this.proxyPort)) : Proxy.NO_PROXY;
                    }
                    return (HttpURLConnection)url.openConnection(this.p);
                }
            }), (ClientConfig)clientConfig);
        } else {
            this.logger.debug(String.format("Direct connection to %s", request.endpoint()));
            this.proxyHost = null;
            this.client = Client.create((ClientConfig)clientConfig);
        }
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostName, SSLSession arg1) {
                for (Pattern trustedHostPattern : JerseyConnector.this.trustedHostPatterns) {
                    if (!trustedHostPattern.matcher(hostName).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, new SecureRandom());
        return sslContext;
    }

    @Provider
    public static class OpenStackObjectMapper
    implements ContextResolver<ObjectMapper> {
        static ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
        static ObjectMapper WRAPPED_MAPPER;

        public ObjectMapper getContext(Class<?> type) {
            return type.getAnnotation(JsonRootName.class) == null ? DEFAULT_MAPPER : WRAPPED_MAPPER;
        }

        static {
            DEFAULT_MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            DEFAULT_MAPPER.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
            DEFAULT_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
            DEFAULT_MAPPER.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            DEFAULT_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
            WRAPPED_MAPPER = new ObjectMapper();
            WRAPPED_MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            WRAPPED_MAPPER.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
            WRAPPED_MAPPER.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
            WRAPPED_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.UNWRAP_ROOT_VALUE});
            WRAPPED_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
            WRAPPED_MAPPER.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
            WRAPPED_MAPPER.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
        }
    }
}

