/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.Limits;
import com.woorea.openstack.nova.model.QuotaSet;
import com.woorea.openstack.nova.model.SimpleTenantUsage;

public class QuotaSetsResource {
    private final OpenStackClient CLIENT;

    public QuotaSetsResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public ShowQuota showQuota(String tenantId) {
        return new ShowQuota(tenantId);
    }

    public UpdateQuota updateQuota(String tenantId, QuotaSet quotaSet) {
        return new UpdateQuota(tenantId, quotaSet);
    }

    public ShowUsage showUsage(String tenantId) {
        return new ShowUsage(tenantId);
    }

    public ShowUsedLimits showUsedLimits() {
        return new ShowUsedLimits();
    }

    public class ShowUsedLimits
    extends OpenStackRequest<Limits> {
        public ShowUsedLimits() {
            super(QuotaSetsResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/limits"), null, Limits.class);
        }
    }

    public class ShowUsage
    extends OpenStackRequest<SimpleTenantUsage> {
        public ShowUsage(String tenantId) {
            super(QuotaSetsResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/os-simple-tenant-usage/").append(tenantId), null, SimpleTenantUsage.class);
        }
    }

    public class UpdateQuota
    extends OpenStackRequest<QuotaSet> {
        public UpdateQuota(String tenantId, QuotaSet quotaSet) {
            super(QuotaSetsResource.this.CLIENT, HttpMethod.PUT, (CharSequence)new StringBuilder("/os-quota-sets/").append(tenantId), Entity.json((Object)quotaSet), QuotaSet.class);
        }
    }

    public class ShowQuota
    extends OpenStackRequest<QuotaSet> {
        public ShowQuota(String tenantId) {
            super(QuotaSetsResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/os-quota-sets/").append(tenantId), null, QuotaSet.class);
        }
    }
}

