/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.InterfaceAttachment;
import com.woorea.openstack.nova.model.InterfaceAttachmentForCreate;
import com.woorea.openstack.nova.model.InterfaceAttachments;
import com.woorea.openstack.nova.model.Metadata;
import com.woorea.openstack.nova.model.Server;
import com.woorea.openstack.nova.model.ServerAction;
import com.woorea.openstack.nova.model.ServerForCreate;
import com.woorea.openstack.nova.model.Servers;
import com.woorea.openstack.nova.model.VirtualInterfaces;
import com.woorea.openstack.nova.model.VolumeAttachment;
import com.woorea.openstack.nova.model.VolumeAttachments;
import java.util.Map;

public class ServersResource {
    private final OpenStackClient CLIENT;

    public ServersResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public AssociateFloatingIpAction associateFloatingIp(String serverId, String floatingIpAddress) {
        ServerAction.AssociateFloatingIp action = new ServerAction.AssociateFloatingIp(floatingIpAddress);
        return new AssociateFloatingIpAction(serverId, action);
    }

    public AssociateSecurityGroupAction associateSecurityGroup(String serverId, String securityGroupName) {
        ServerAction.AddSecurityGroup securityGroup = new ServerAction.AddSecurityGroup();
        securityGroup.setName(securityGroupName);
        return new AssociateSecurityGroupAction(serverId, securityGroup);
    }

    public AttachVolume attachVolume(String serverId, String volumeId, String device) {
        VolumeAttachment volumeAttachment = new VolumeAttachment();
        volumeAttachment.setVolumeId(volumeId);
        volumeAttachment.setDevice(device);
        return new AttachVolume(serverId, volumeAttachment);
    }

    public Boot boot(ServerForCreate server) {
        return new Boot(server);
    }

    public ChangePasswordAction changePassword(String serverId, String adminPass) {
        ServerAction.ChangePassword changePassword = new ServerAction.ChangePassword();
        changePassword.setAdminPass(adminPass);
        return new ChangePasswordAction(serverId, changePassword);
    }

    public ConfirmResizeAction confirmResize(String serverId) {
        return new ConfirmResizeAction(serverId);
    }

    public CreateBackupAction createBackup(String serverId, ServerAction.CreateBackup action) {
        return new CreateBackupAction(serverId, action);
    }

    public CreateImageAction createImage(String serverId, String name, Map<String, String> metadata) {
        ServerAction.CreateImage createImage = new ServerAction.CreateImage();
        createImage.setName(name);
        createImage.setMetadata(metadata);
        return new CreateImageAction(serverId, createImage);
    }

    public CreateInterfaceAttachment createInterfaceAttachment(String serverId, InterfaceAttachmentForCreate interfaceAttachmentForCreate) {
        return new CreateInterfaceAttachment(serverId, interfaceAttachmentForCreate);
    }

    public CreateOrUpdateMetadata createOrUpdateMetadata(String id, Metadata metadata) {
        return new CreateOrUpdateMetadata(id, metadata);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public DeleteMetadata deleteMetadata(String id, String key) {
        return new DeleteMetadata(id, key);
    }

    public DetachVolume detachVolume(String serverId, String volumeId) {
        return new DetachVolume(serverId, volumeId);
    }

    public DetachInterfaceAttachment detachInterfaceAttachment(String serverId, String portId) {
        return new DetachInterfaceAttachment(serverId, portId);
    }

    public DisassociateFloatingIpAction disassociateFloatingIp(String serverId, String floatingIpAddress) {
        ServerAction.DisassociateFloatingIp action = new ServerAction.DisassociateFloatingIp(floatingIpAddress);
        return new DisassociateFloatingIpAction(serverId, action);
    }

    public DisassociateSecurityGroupAction disassociateSecurityGroup(String serverId, String securityGroupName) {
        ServerAction.RemoveSecurityGroup securityGroup = new ServerAction.RemoveSecurityGroup();
        securityGroup.setName(securityGroupName);
        return new DisassociateSecurityGroupAction(serverId, securityGroup);
    }

    public EvacuateAction evacuate(String serverId) {
        return this.evacuate(serverId, null, null, null);
    }

    public EvacuateAction evacuate(String serverId, String host) {
        return this.evacuate(serverId, host, null, null);
    }

    public EvacuateAction evacuate(String serverId, String host, String adminPassword, Boolean sharedStorage) {
        ServerAction.Evacuate entity = new ServerAction.Evacuate();
        entity.setAdminPassword(host);
        if (adminPassword != null && adminPassword.length() > 0) {
            entity.setAdminPassword(adminPassword);
        }
        if (sharedStorage != null) {
            entity.setSharedStorage(sharedStorage.booleanValue());
        } else {
            entity.setSharedStorage(false);
        }
        return new EvacuateAction(serverId, entity);
    }

    public GetConsoleOutputAction getConsoleOutput(String id, int length) {
        ServerAction.GetConsoleOutput action = new ServerAction.GetConsoleOutput(Integer.valueOf(length));
        return new GetConsoleOutputAction(id, action);
    }

    public GetVncConsoleAction getVncConsole(String id, String type) {
        ServerAction.GetVncConsole action = new ServerAction.GetVncConsole(type);
        return new GetVncConsoleAction(id, action);
    }

    public List list(boolean detail) {
        return new List(detail);
    }

    public ListInterfaceAttachments listInterfaceAttachments(String serverId) {
        return new ListInterfaceAttachments(serverId);
    }

    public ListVirtualInterfaces listVirtualInterfaces(String serverId) {
        return new ListVirtualInterfaces(serverId);
    }

    public ListVolumeAttachments listVolumeAttachments(String serverId) {
        return new ListVolumeAttachments(serverId);
    }

    public LockAction lock(String serverId) {
        return new LockAction(serverId);
    }

    public MigrateAction migrate(String serverId) {
        return new MigrateAction(serverId);
    }

    public PauseAction pause(String serverId) {
        return new PauseAction(serverId);
    }

    public RebootAction reboot(String serverId, String rebootType) {
        ServerAction.Reboot reboot = new ServerAction.Reboot();
        reboot.setType(rebootType);
        return new RebootAction(serverId, reboot);
    }

    public RebuildAction rebuild(String serverId, ServerAction.Rebuild rebuild) {
        return new RebuildAction(serverId, rebuild);
    }

    public ReplaceMetadata replaceMetadata(String id, Metadata metadata) {
        return new ReplaceMetadata(id, metadata);
    }

    public RescueServer rescue(String serverId, String adminPass) {
        ServerAction.Rescue action = new ServerAction.Rescue(adminPass);
        return new RescueServer(serverId, action);
    }

    public ResizeAction resize(String serverId, String flavorId, String diskConfig) {
        ServerAction.Resize resize = new ServerAction.Resize();
        resize.setFlavorRef(flavorId);
        resize.setDiskConfig(diskConfig);
        return new ResizeAction(serverId, resize);
    }

    public ResumeAction resume(String serverId) {
        return new ResumeAction(serverId);
    }

    public RevertResizeAction revertResize(String serverId) {
        return new RevertResizeAction(serverId);
    }

    public Show show(String id) {
        return new Show(id);
    }

    public ShowInterfaceAttachment showInterfaceAttachment(String serverId, String interfaceAttachmentId) {
        return new ShowInterfaceAttachment(serverId, interfaceAttachmentId);
    }

    public ShowMetadata showMetadata(String id) {
        return new ShowMetadata(id);
    }

    public ShowVolumeAttachment showVolumeAttachment(String serverId, String volumeAttachmentId) {
        return new ShowVolumeAttachment(serverId, volumeAttachmentId);
    }

    public StartAction start(String id) {
        return new StartAction(id);
    }

    public StopAction stop(String id) {
        return new StopAction(id);
    }

    public SuspendAction suspend(String serverId) {
        return new SuspendAction(serverId);
    }

    public UnlockAction unlock(String serverId) {
        return new UnlockAction(serverId);
    }

    public UnpauseAction unpause(String serverId) {
        return new UnpauseAction(serverId);
    }

    public UnrescueAction unrescue(String serverId) {
        return new UnrescueAction(serverId);
    }

    public UpdateServer update(String serverId, String name, String accessIPv4, String accessIPv6) {
        Server server = new Server();
        return new UpdateServer(serverId, server);
    }

    public class UpdateServer
    extends OpenStackRequest<Server> {
        private Server server;

        public UpdateServer(String id, Server server) {
            super(ServersResource.this.CLIENT, HttpMethod.PUT, (CharSequence)new StringBuilder("/servers/").append(id), Entity.json((Object)server), Server.class);
            this.server = server;
        }
    }

    public class UnrescueAction
    extends Action<Void> {
        public UnrescueAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Unrescue()), Void.class);
        }
    }

    public class UnpauseAction
    extends Action<Void> {
        public UnpauseAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Unpause()), Void.class);
        }
    }

    public class UnlockAction
    extends Action<Void> {
        public UnlockAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Unlock()), Void.class);
        }
    }

    public class SuspendAction
    extends Action<Void> {
        public SuspendAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Suspend()), Void.class);
        }
    }

    public class StopAction
    extends Action<Void> {
        public StopAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Stop()), Void.class);
        }
    }

    public class StartAction
    extends Action<Void> {
        public StartAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Start()), Void.class);
        }
    }

    public class ShowVolumeAttachment
    extends OpenStackRequest<VolumeAttachment> {
        public ShowVolumeAttachment(String serverId, String volumeAttachmentId) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-volume_attachments/").append(volumeAttachmentId), null, VolumeAttachment.class);
        }
    }

    public class ShowServerAddresses
    extends OpenStackRequest<Server.Addresses> {
        public ShowServerAddresses(String id) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(id).append("/ips"), null, Server.Addresses.class);
        }
    }

    public class ShowMetadata
    extends OpenStackRequest<Metadata> {
        public ShowMetadata(String id) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(id).append("/metadata"), null, Metadata.class);
        }
    }

    public class ShowInterfaceAttachment
    extends OpenStackRequest<InterfaceAttachment> {
        public ShowInterfaceAttachment(String serverId, String interfaceAttachmentId) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-interface/").append(interfaceAttachmentId), null, InterfaceAttachment.class);
        }
    }

    public class Show
    extends OpenStackRequest<Server> {
        public Show(String id) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(id), null, Server.class);
        }
    }

    public class RevertResizeAction
    extends Action<Server> {
        public RevertResizeAction(String id) {
            super(id, Entity.json((Object)new ServerAction.RevertResize()), Server.class);
        }
    }

    public class ResumeAction
    extends Action<Void> {
        public ResumeAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Resume()), Void.class);
        }
    }

    public class ResizeAction
    extends Action<Void> {
        private ServerAction.Resize action;

        public ResizeAction(String id, ServerAction.Resize action) {
            super(id, Entity.json((Object)action), Void.class);
        }
    }

    public class RescueServer
    extends OpenStackRequest<Void> {
        public RescueServer(String id, ServerAction.Rescue action) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(id).append("/action"), Entity.json((Object)action), Void.class);
        }
    }

    public class ReplaceMetadata
    extends OpenStackRequest<Metadata> {
        public ReplaceMetadata(String id, Metadata metadata) {
            super(ServersResource.this.CLIENT, HttpMethod.PUT, (CharSequence)new StringBuilder("/servers/").append(id).append("/metadata"), Entity.json((Object)metadata), Metadata.class);
        }
    }

    public class RebuildAction
    extends Action<Server> {
        private ServerAction.Rebuild action;

        public RebuildAction(String id, ServerAction.Rebuild action) {
            super(id, Entity.json((Object)action), Server.class);
        }
    }

    public class RebootAction
    extends Action<Void> {
        private ServerAction.Reboot action;

        public RebootAction(String id, ServerAction.Reboot action) {
            super(id, Entity.json((Object)action), Void.class);
        }
    }

    public class PauseAction
    extends Action<Void> {
        public PauseAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Pause()), Void.class);
        }
    }

    public class MigrateAction
    extends Action<Void> {
        public MigrateAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Migrate()), Void.class);
        }
    }

    public class LockAction
    extends Action<Void> {
        public LockAction(String id) {
            super(id, Entity.json((Object)new ServerAction.Lock()), Void.class);
        }
    }

    public class ListVolumeAttachments
    extends OpenStackRequest<VolumeAttachments> {
        public ListVolumeAttachments(String serverId) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-volume_attachments"), null, VolumeAttachments.class);
        }
    }

    public class ListVirtualInterfaces
    extends OpenStackRequest<VirtualInterfaces> {
        public ListVirtualInterfaces(String serverId) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-virtual-interface"), null, VirtualInterfaces.class);
        }
    }

    public class ListInterfaceAttachments
    extends OpenStackRequest<InterfaceAttachments> {
        public ListInterfaceAttachments(String serverId) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-interface"), null, InterfaceAttachments.class);
        }
    }

    public class List
    extends OpenStackRequest<Servers> {
        public List(boolean detail) {
            super(ServersResource.this.CLIENT, HttpMethod.GET, (CharSequence)(detail ? "/servers/detail" : "/servers"), null, Servers.class);
        }
    }

    public class GetVncConsoleAction
    extends Action<ServerAction.VncConsole> {
        public GetVncConsoleAction(String id, ServerAction.GetVncConsole action) {
            super(id, Entity.json((Object)action), ServerAction.VncConsole.class);
        }
    }

    public class GetConsoleOutputAction
    extends Action<ServerAction.ConsoleOutput> {
        public GetConsoleOutputAction(String id, ServerAction.GetConsoleOutput action) {
            super(id, Entity.json((Object)action), ServerAction.ConsoleOutput.class);
        }
    }

    public class EvacuateAction
    extends Action<Void> {
        public EvacuateAction(String uuid, ServerAction.Evacuate entity) {
            super(uuid, Entity.json((Object)entity), Void.class);
        }
    }

    public class DisassociateSecurityGroupAction
    extends OpenStackRequest<Void> {
        public DisassociateSecurityGroupAction(String id, ServerAction.RemoveSecurityGroup securityGroup) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(id).append("/action"), Entity.json((Object)securityGroup), Void.class);
        }
    }

    public class DisassociateFloatingIpAction
    extends Action<Void> {
        public DisassociateFloatingIpAction(String id, ServerAction.DisassociateFloatingIp action) {
            super(id, Entity.json((Object)action), Void.class);
        }
    }

    public class DetachVolume
    extends OpenStackRequest<Void> {
        public DetachVolume(String serverId, String volumeId) {
            super(ServersResource.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-volume_attachments/").append(volumeId), null, Void.class);
        }
    }

    public class DetachInterfaceAttachment
    extends OpenStackRequest<Void> {
        public DetachInterfaceAttachment(String serverId, String portId) {
            super(ServersResource.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-interface/").append(portId), null, Void.class);
        }
    }

    public class DeleteMetadata
    extends OpenStackRequest<Void> {
        public DeleteMetadata(String id, String key) {
            super(ServersResource.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuilder("/servers/").append(id).append("/metadata/").append(key), null, Void.class);
        }
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(ServersResource.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuilder("/servers/").append(id), null, Void.class);
        }
    }

    public class CreateOrUpdateMetadata
    extends OpenStackRequest<Metadata> {
        public CreateOrUpdateMetadata(String id, Metadata metadata) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(id).append("/metadata"), Entity.json((Object)metadata), Metadata.class);
        }
    }

    public class CreateInterfaceAttachment
    extends OpenStackRequest<InterfaceAttachment> {
        public CreateInterfaceAttachment(String serverId, InterfaceAttachmentForCreate action) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-interface"), Entity.json((Object)action), InterfaceAttachment.class);
        }
    }

    public class CreateImageAction
    extends Action<Void> {
        public CreateImageAction(String id, ServerAction.CreateImage createImage) {
            super(id, Entity.json((Object)createImage), Void.class);
        }
    }

    public class CreateBackupAction
    extends Action<Void> {
        public CreateBackupAction(String id, ServerAction.CreateBackup action) {
            super(id, Entity.json((Object)action), Void.class);
        }
    }

    public class ConfirmResizeAction
    extends Action<Void> {
        public ConfirmResizeAction(String id) {
            super(id, Entity.json((Object)new ServerAction.ConfirmResize()), Void.class);
        }
    }

    public class ChangePasswordAction
    extends Action<Server> {
        private ServerAction.ChangePassword action;

        public ChangePasswordAction(String id, ServerAction.ChangePassword action) {
            super(id, Entity.json((Object)action), Server.class);
        }
    }

    public class Boot
    extends OpenStackRequest<Server> {
        private ServerForCreate server;

        public Boot(ServerForCreate server) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)"/servers", Entity.json((Object)server), Server.class);
            this.server = server;
        }
    }

    public class AttachVolume
    extends OpenStackRequest<Void> {
        public AttachVolume(String serverId, VolumeAttachment volumeAttachment) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(serverId).append("/os-volume_attachments"), Entity.json((Object)volumeAttachment), Void.class);
        }
    }

    public class AssociateSecurityGroupAction
    extends OpenStackRequest<Void> {
        public AssociateSecurityGroupAction(String id, ServerAction.AddSecurityGroup securityGroup) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(id).append("/action"), Entity.json((Object)securityGroup), Void.class);
        }
    }

    public class AssociateFloatingIpAction
    extends Action<Void> {
        public AssociateFloatingIpAction(String id, ServerAction.AssociateFloatingIp action) {
            super(id, Entity.json((Object)action), Void.class);
        }
    }

    public abstract class Action<T>
    extends OpenStackRequest<T> {
        public Action(String id, Entity<?> entity, Class<T> returnType) {
            super(ServersResource.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/servers/").append(id).append("/action"), entity, returnType);
        }
    }
}

