/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api.extensions;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.Metadata;
import com.woorea.openstack.nova.model.Volume;
import com.woorea.openstack.nova.model.VolumeForCreate;
import com.woorea.openstack.nova.model.VolumeForImageCreate;
import com.woorea.openstack.nova.model.Volumes;

public class VolumesExtension {
    private final OpenStackClient CLIENT;

    public VolumesExtension(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list(boolean detail) {
        return new List(detail);
    }

    public Create create(VolumeForCreate volume) {
        return new Create(volume);
    }

    public UploadToImage uploadToImage(VolumeForImageCreate volumeForImage) {
        return new UploadToImage(volumeForImage);
    }

    public Show show(String id) {
        return new Show(id);
    }

    public ShowMetadata showMetadata(String id) {
        return new ShowMetadata(id);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(VolumesExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-volumes/" + id), null, Void.class);
        }
    }

    public class ShowMetadata
    extends OpenStackRequest<Metadata> {
        public ShowMetadata(String id) {
            super(VolumesExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-volumes/" + id + "/metadata"), null, Metadata.class);
        }
    }

    public class Show
    extends OpenStackRequest<Volume> {
        public Show(String id) {
            super(VolumesExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-volumes/" + id), null, Volume.class);
        }
    }

    public class UploadToImage
    extends OpenStackRequest<Void> {
        public UploadToImage(VolumeForImageCreate volumeForImageCreate) {
            super(VolumesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("/volumes/").append(volumeForImageCreate.getVolumeId() + "/action"), Entity.json((Object)volumeForImageCreate), Void.class);
        }
    }

    public class Create
    extends OpenStackRequest<Volume> {
        public Create(VolumeForCreate volume) {
            super(VolumesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)"/os-volumes", Entity.json((Object)volume), Volume.class);
        }
    }

    public class List
    extends OpenStackRequest<Volumes> {
        public List(boolean detail) {
            super(VolumesExtension.this.CLIENT, HttpMethod.GET, (CharSequence)(detail ? "/os-volumes/detail" : "/os-volumes"), null, Volumes.class);
        }
    }
}

