/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.Image;
import com.woorea.openstack.nova.model.Images;
import com.woorea.openstack.nova.model.Metadata;

public class ImagesResource {
    private final OpenStackClient CLIENT;

    public ImagesResource(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list(boolean detail) {
        return new List(detail);
    }

    public Create create(Image image) {
        return new Create(image);
    }

    public Show show(String id) {
        return new Show(id);
    }

    public ShowMetadata showMetadata(String id) {
        return new ShowMetadata(id);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/images/" + id), null, Void.class);
        }
    }

    public class ShowMetadata
    extends OpenStackRequest<Metadata> {
        public ShowMetadata(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, (CharSequence)("/images/" + id + "/metadata"), null, Metadata.class);
        }
    }

    public class Show
    extends OpenStackRequest<Image> {
        public Show(String id) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, (CharSequence)("/images/" + id), null, Image.class);
        }
    }

    public class Create
    extends OpenStackRequest<Image> {
        private Image image;

        public Create(Image image) {
            super(ImagesResource.this.CLIENT, HttpMethod.POST, (CharSequence)"/images", Entity.json((Object)image), Image.class);
            this.image = image;
        }
    }

    public class List
    extends OpenStackRequest<Images> {
        public List(boolean detail) {
            super(ImagesResource.this.CLIENT, HttpMethod.GET, (CharSequence)(detail ? "/images/detail" : "/images"), null, Images.class);
        }
    }
}

