/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api.extensions;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.HostAggregate;
import com.woorea.openstack.nova.model.HostAggregates;

public class AggregatesExtension {
    private final OpenStackClient CLIENT;

    public AggregatesExtension(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list() {
        return new List();
    }

    public ShowAggregate showAggregate(String id) {
        return new ShowAggregate(id);
    }

    public UpdateAggregateMetadata updateAggregateMetadata(String id, String name, String availabilityZone) {
        return new UpdateAggregateMetadata(id, name, availabilityZone);
    }

    public CreateAggregate createAggregate(String aggregateName, String availabilityZoneName) {
        return new CreateAggregate(aggregateName, availabilityZoneName);
    }

    public DeleteAggregate deleteAggregate(String id) {
        return new DeleteAggregate(id);
    }

    public AddHost addHost(String aggregateId, String hostId) {
        return new AddHost(aggregateId, hostId);
    }

    public RemoveHost removeHost(String aggregateId, String hostId) {
        return new RemoveHost(hostId, aggregateId);
    }

    public SetMetadata setMetadata(String aggregateId, String key, String value) {
        return new SetMetadata(aggregateId, key, value);
    }

    public class SetMetadata
    extends OpenStackRequest<HostAggregate> {
        public SetMetadata(String aggregateId, String key, String value) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuffer("/os-aggregates/").append(aggregateId).append("/action"), Entity.json((Object)("{\"set_metadata\": {\"metadata\": { \"" + key + "\": \"" + value + "\" }}}")), HostAggregate.class);
        }
    }

    public class RemoveHost
    extends OpenStackRequest<HostAggregate> {
        public RemoveHost(String hostId, String aggregateId) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuffer("/os-aggregates/").append(aggregateId).append("/action"), Entity.json((Object)("{\"remove_host\": {\"host\": \"" + hostId + "\" }}")), HostAggregate.class);
        }
    }

    public class AddHost
    extends OpenStackRequest<HostAggregate> {
        public AddHost(String aggregateId, String hostId) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuffer("/os-aggregates/").append(aggregateId).append("/action"), Entity.json((Object)("{\"add_host\": {\"host\": \"" + hostId + "\" }}")), HostAggregate.class);
        }
    }

    public class DeleteAggregate
    extends OpenStackRequest<Void> {
        public DeleteAggregate(String id) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuffer("/os-aggregates/").append(id), null, null);
        }
    }

    public class CreateAggregate
    extends OpenStackRequest<HostAggregate> {
        public CreateAggregate(String name, String availabilityZone) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuffer("/os-aggregates"), availabilityZone == null ? Entity.json((Object)("{\"aggregate\": {\"name\": \"" + name + "\", \"availability_zone\": null }}")) : Entity.json((Object)("{\"aggregate\": {\"name\": \"" + name + "\", \"availability_zone\": \"" + availabilityZone + "\" }}")), HostAggregate.class);
        }
    }

    public class UpdateAggregateMetadata
    extends OpenStackRequest<HostAggregate> {
        public UpdateAggregateMetadata(String id, String name, String availabilityZone) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.PUT, (CharSequence)new StringBuffer("/os-aggregates/").append(id), availabilityZone == null ? Entity.json((Object)("{\"aggregate\": {\"name\": \"" + name + "\" }}")) : Entity.json((Object)("{\"aggregate\": {\"name\": \"" + name + "\", \"availability_zone\": \"" + availabilityZone + "\" }}")), HostAggregate.class);
        }
    }

    public class ShowAggregate
    extends OpenStackRequest<HostAggregate> {
        public ShowAggregate(String id) {
            super(AggregatesExtension.this.CLIENT, HttpMethod.GET, (CharSequence)new StringBuffer("/os-aggregates/").append(id), null, HostAggregate.class);
        }
    }

    public class List
    extends OpenStackRequest<HostAggregates> {
        public List() {
            super(AggregatesExtension.this.CLIENT, HttpMethod.GET, (CharSequence)"/os-aggregates", null, HostAggregates.class);
        }
    }
}

