/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api.extensions;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.Network;
import com.woorea.openstack.nova.model.Networks;

public class NetworksExtension {
    private final OpenStackClient CLIENT;

    public NetworksExtension(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List list() {
        return new List();
    }

    public ListExtended listExtended() {
        return new ListExtended();
    }

    public Show show(String id) {
        return new Show(id);
    }

    public ShowExtended showExtended(String id) {
        return new ShowExtended(id);
    }

    public Delete delete(String id) {
        return new Delete(id);
    }

    public Disassociate disassociate(String id) {
        return new Disassociate(id);
    }

    public Create create(Network net) {
        return new Create(net);
    }

    public CreateExtended createExtended(Network net) {
        return new CreateExtended(net);
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(String id) {
            super(NetworksExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-networks/" + id), null, Void.class);
        }
    }

    public class Disassociate
    extends OpenStackRequest<Void> {
        public Disassociate(String id) {
            super(NetworksExtension.this.CLIENT, HttpMethod.POST, (CharSequence)("/os-networks/" + id), Entity.json((Object)"{\"action\":\"disassociate\"}"), Void.class);
        }
    }

    public class ShowExtended
    extends OpenStackRequest<Network> {
        public ShowExtended(String id) {
            super(NetworksExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-extended-networks/" + id), null, Network.class);
        }
    }

    public class Show
    extends OpenStackRequest<Network> {
        public Show(String id) {
            super(NetworksExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-networks/" + id), null, Network.class);
        }
    }

    public class CreateExtended
    extends OpenStackRequest<Network> {
        private Network network;

        public CreateExtended(Network network) {
            super(NetworksExtension.this.CLIENT, HttpMethod.POST, (CharSequence)"/os-extended-networks", Entity.json((Object)network), Network.class);
            this.network = network;
        }
    }

    public class Create
    extends OpenStackRequest<Network> {
        private Network network;

        public Create(Network network) {
            super(NetworksExtension.this.CLIENT, HttpMethod.POST, (CharSequence)"/os-networks", Entity.json((Object)network), Network.class);
            this.network = network;
        }
    }

    public class ListExtended
    extends OpenStackRequest<Networks> {
        public ListExtended() {
            super(NetworksExtension.this.CLIENT, HttpMethod.GET, (CharSequence)"/os-extended-networks", null, Networks.class);
        }
    }

    public class List
    extends OpenStackRequest<Networks> {
        public List() {
            super(NetworksExtension.this.CLIENT, HttpMethod.GET, (CharSequence)"/os-networks", null, Networks.class);
        }
    }
}

