/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.nova.api.extensions;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.nova.model.SecurityGroup;
import com.woorea.openstack.nova.model.SecurityGroupForCreate;
import com.woorea.openstack.nova.model.SecurityGroupRuleForCreate;
import com.woorea.openstack.nova.model.SecurityGroups;

public class SecurityGroupsExtension {
    private final OpenStackClient CLIENT;

    public SecurityGroupsExtension(OpenStackClient client) {
        this.CLIENT = client;
    }

    public List listSecurityGroups() {
        return new List();
    }

    public Create createSecurityGroup(String name, String description) {
        return new Create(new SecurityGroupForCreate(name, description));
    }

    public Create createSecurityGroup(SecurityGroupForCreate model) {
        return new Create(model);
    }

    public Create createSecurityGroup(String name) {
        return this.createSecurityGroup(name, null);
    }

    public Show showSecurityGroup(Integer id) {
        return new Show(String.valueOf(id));
    }

    public Show showSecurityGroup(String id) {
        return new Show(id);
    }

    public Delete deleteSecurityGroup(Integer id) {
        return new Delete(String.valueOf(id));
    }

    public Delete deleteSecurityGroup(String id) {
        return new Delete(id);
    }

    public CreateRule createSecurityGroupRule(Integer parentSecurityGroupId, String ipProtocol, Integer fromPort, Integer toPort, String cidr) {
        SecurityGroupRuleForCreate securityGroupRuleForCreate = new SecurityGroupRuleForCreate(parentSecurityGroupId, ipProtocol, fromPort, toPort, cidr);
        return new CreateRule(securityGroupRuleForCreate);
    }

    public CreateRule createSecurityGroupRule(Integer parentSecurityGroupId, String ipProtocol, Integer fromPort, Integer toPort, Integer sourceGroupId) {
        SecurityGroupRuleForCreate securityGroupRuleForCreate = new SecurityGroupRuleForCreate(parentSecurityGroupId, ipProtocol, fromPort, toPort, sourceGroupId);
        return new CreateRule(securityGroupRuleForCreate);
    }

    public CreateRule createSecurityGroupRule(String parentSecurityGroupId, String ipProtocol, Integer fromPort, Integer toPort, String cidr) {
        SecurityGroupRuleForCreate securityGroupRuleForCreate = new SecurityGroupRuleForCreate(parentSecurityGroupId, ipProtocol, fromPort, toPort, cidr);
        return new CreateRule(securityGroupRuleForCreate);
    }

    public CreateRule createSecurityGroupRule(String parentSecurityGroupId, String sourceGroupId, String ipProtocol, Integer fromPort, Integer toPort) {
        SecurityGroupRuleForCreate securityGroupRuleForCreate = new SecurityGroupRuleForCreate(parentSecurityGroupId, sourceGroupId, ipProtocol, fromPort, toPort);
        return new CreateRule(securityGroupRuleForCreate);
    }

    public DeleteRule deleteSecurityGroupRule(String id) {
        return new DeleteRule(id);
    }

    public DeleteRule deleteSecurityGroupRule(Integer id) {
        return new DeleteRule(String.valueOf(id));
    }

    public class DeleteRule
    extends OpenStackRequest<Void> {
        public DeleteRule(Integer id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-security-group-rules/" + String.valueOf(id)), null, Void.class);
        }

        public DeleteRule(String id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-security-group-rules/" + String.valueOf(id)), null, Void.class);
        }
    }

    public class CreateRule
    extends OpenStackRequest<SecurityGroup.Rule> {
        private SecurityGroupRuleForCreate securityGroupRuleForCreate;

        public CreateRule(SecurityGroupRuleForCreate securityGroupRuleForCreate) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.POST, (CharSequence)"/os-security-group-rules", Entity.json((Object)securityGroupRuleForCreate), SecurityGroup.Rule.class);
            this.securityGroupRuleForCreate = securityGroupRuleForCreate;
        }
    }

    public class Delete
    extends OpenStackRequest<Void> {
        public Delete(Integer id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-security-groups/" + String.valueOf(id)), null, Void.class);
        }

        public Delete(String id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.DELETE, (CharSequence)("/os-security-groups/" + id), null, Void.class);
        }
    }

    public class Show
    extends OpenStackRequest<SecurityGroup> {
        public Show(Integer id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-security-groups/" + id), null, SecurityGroup.class);
        }

        public Show(String id) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.GET, (CharSequence)("/os-security-groups/" + id), null, SecurityGroup.class);
        }
    }

    public class Create
    extends OpenStackRequest<SecurityGroup> {
        private SecurityGroupForCreate securityGroupForCreate;

        public Create(SecurityGroupForCreate securityGroupForCreate) {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.POST, (CharSequence)"/os-security-groups", Entity.json((Object)securityGroupForCreate), SecurityGroup.class);
            this.securityGroupForCreate = securityGroupForCreate;
        }
    }

    public class List
    extends OpenStackRequest<SecurityGroups> {
        public List() {
            super(SecurityGroupsExtension.this.CLIENT, HttpMethod.GET, (CharSequence)"/os-security-groups", null, SecurityGroups.class);
        }
    }
}

