/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.base.client;

import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClientConnector;
import com.woorea.openstack.base.client.OpenStackConnectException;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.base.client.OpenStackResponseException;
import com.woorea.openstack.base.client.OpenStackSimpleTokenProvider;
import com.woorea.openstack.base.client.OpenStackTokenProvider;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStackClient {
    protected String endpoint;
    protected OpenStackTokenProvider tokenProvider;
    protected OpenStackClientConnector connector;
    protected Properties properties = new Properties();
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected OpenStackClientConnector DEFAULT_CONNECTOR;

    private OpenStackClient() {
        this.loadDefaultConnector();
    }

    public OpenStackClient(String endpoint) {
        this.loadDefaultConnector();
        this.endpoint = endpoint;
        this.connector = this.DEFAULT_CONNECTOR;
    }

    public OpenStackClient(String endpoint, OpenStackClientConnector connector) {
        this.endpoint = endpoint;
        if (connector == null) {
            this.loadDefaultConnector();
            this.connector = this.DEFAULT_CONNECTOR;
        } else {
            this.connector = connector;
        }
    }

    private void loadDefaultConnector() {
        block0: {
            OpenStackClientConnector clientConnector;
            ServiceLoader<OpenStackClientConnector> connectorLoader = ServiceLoader.load(OpenStackClientConnector.class);
            Iterator<OpenStackClientConnector> iterator = connectorLoader.iterator();
            if (!iterator.hasNext()) break block0;
            this.DEFAULT_CONNECTOR = clientConnector = iterator.next();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public <T> OpenStackResponse request(OpenStackRequest<T> request) throws OpenStackConnectException, OpenStackResponseException {
        OpenStackResponseException authException = null;
        int retries = Integer.valueOf("1");
        try {
            retries = Integer.valueOf(this.properties.getProperty("com.woorea.openstack.auth.retries", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (int i = 0; i <= retries; ++i) {
            request.endpoint(this.endpoint);
            if (this.tokenProvider != null) {
                request.header("X-Auth-Token", this.tokenProvider.getToken());
            }
            try {
                OpenStackResponse response = this.connector.request(request);
                int status = response.getStatus();
                if (status >= 400) {
                    throw new OpenStackResponseException("Unexpected status received from Openstack", status, response);
                }
                return response;
            }
            catch (OpenStackResponseException e) {
                if (e.getStatus() != 401 || this.tokenProvider == null) {
                    throw e;
                }
                authException = e;
                this.tokenProvider.expireToken();
                continue;
            }
        }
        throw authException;
    }

    public <T> T execute(OpenStackRequest<T> request) throws OpenStackConnectException, OpenStackResponseException {
        OpenStackResponse response = this.request(request);
        return request.returnType() != null && request.returnType() != Void.class ? (T)response.getEntity(request.returnType()) : null;
    }

    public void property(String property, String value) {
        this.properties.put(property, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setTokenProvider(OpenStackTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public void token(String token) {
        this.setTokenProvider(new OpenStackSimpleTokenProvider(token));
    }

    public <R> OpenStackRequest<R> get(String path, Class<R> returnType) {
        return new OpenStackRequest<R>(this, HttpMethod.GET, path, null, returnType);
    }
}

