/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.common.client;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;

public class JULWrapper
extends java.util.logging.Logger {
    private Logger logger;

    public JULWrapper(Logger logger) {
        super(logger.getName(), null);
        this.logger = logger;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return null;
    }

    @Override
    public String getResourceBundleName() {
        return null;
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public void log(LogRecord record) {
        super.log(record);
    }

    @Override
    public void log(Level level, String msg) {
        this.writeLog(level, msg, null, null);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.writeLog(level, msg, null, new Object[]{param1});
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        this.writeLog(level, msg, null, params);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        this.writeLog(level, msg, thrown, null);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.writeLog(level, msg, null, null);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.writeLog(level, msg, null, new Object[]{param1});
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        this.writeLog(level, msg, null, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        this.writeLog(level, msg, thrown, null);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        this.writeLog(level, msg, null, null);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        this.writeLog(level, msg, null, new Object[]{param1});
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        this.writeLog(level, msg, null, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        this.writeLog(level, msg, thrown, null);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.writeLog(Level.FINER, "ENTRY {0}.{1}", null, new Object[]{sourceClass, sourceMethod});
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.writeLog(Level.FINER, "ENTRY {0}.{1} - {2}", null, new Object[]{sourceClass, sourceMethod, param1});
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        Object[] args = new Object[params.length + 2];
        args[0] = sourceClass;
        args[1] = sourceMethod;
        System.arraycopy(params, 0, args, 2, params.length);
        this.writeLog(Level.FINER, "ENTRY {0}.{1} - {2}", null, args);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.writeLog(Level.FINER, "RETURN {0}.{1}", null, new Object[]{sourceClass, sourceMethod});
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.writeLog(Level.FINER, "RETURN {0}.{1} - {2}", null, new Object[]{sourceClass, sourceMethod, result});
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.writeLog(Level.FINER, "THROW {0}.{1}", thrown, new Object[]{sourceClass, sourceMethod});
    }

    @Override
    public void severe(String msg) {
        this.writeLog(Level.SEVERE, msg, null, null);
    }

    @Override
    public void warning(String msg) {
        this.writeLog(Level.WARNING, msg, null, null);
    }

    @Override
    public void info(String msg) {
        this.writeLog(Level.INFO, msg, null, null);
    }

    @Override
    public void config(String msg) {
        this.writeLog(Level.CONFIG, msg, null, null);
    }

    @Override
    public void fine(String msg) {
        this.writeLog(Level.FINE, msg, null, null);
    }

    @Override
    public void finer(String msg) {
        this.writeLog(Level.FINER, msg, null, null);
    }

    @Override
    public void finest(String msg) {
        this.writeLog(Level.FINEST, msg, null, null);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
    }

    @Override
    public Level getLevel() {
        if (this.logger.isTraceEnabled()) {
            return Level.FINEST;
        }
        if (this.logger.isDebugEnabled()) {
            return Level.FINER;
        }
        if (this.logger.isInfoEnabled()) {
            return Level.FINE;
        }
        if (this.logger.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.logger.isErrorEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public boolean isLoggable(Level level) {
        if ((Level.FINEST.equals(level) || Level.CONFIG.equals(level) || Level.ALL.equals(level)) && this.logger.isTraceEnabled()) {
            return true;
        }
        if (Level.FINER.equals(level) && this.logger.isDebugEnabled()) {
            return true;
        }
        if (Level.FINE.equals(level) && this.logger.isInfoEnabled()) {
            return true;
        }
        if (Level.WARNING.equals(level) && this.logger.isWarnEnabled()) {
            return true;
        }
        return Level.SEVERE.equals(level) && this.logger.isErrorEnabled();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
    }

    @Override
    public Handler[] getHandlers() {
        return super.getHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        super.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public boolean getUseParentHandlers() {
        return super.getUseParentHandlers();
    }

    @Override
    public java.util.logging.Logger getParent() {
        return super.getParent();
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        super.setParent(parent);
    }

    private void writeLog(Level level, String msg, Throwable t, Object[] params) {
        if (level.equals(Level.FINEST)) {
            if (this.logger.isTraceEnabled()) {
                if (t != null) {
                    if (params == null || params.length == 0) {
                        this.logger.trace(msg, t);
                    } else {
                        this.logger.trace(MessageFormat.format(msg, params), t);
                    }
                } else if (params == null || params.length == 0) {
                    this.logger.trace(msg);
                } else {
                    this.logger.trace(MessageFormat.format(msg, params));
                }
            }
        } else if (level.equals(Level.CONFIG) || level.equals(Level.FINER)) {
            if (this.logger.isDebugEnabled()) {
                if (t != null) {
                    if (params == null || params.length == 0) {
                        this.logger.debug(msg, t);
                    } else {
                        this.logger.debug(MessageFormat.format(msg, params), t);
                    }
                } else if (params == null || params.length == 0) {
                    this.logger.debug(msg);
                } else {
                    this.logger.debug(MessageFormat.format(msg, params));
                }
            }
        } else if (level.equals(Level.INFO) || level.equals(Level.FINE)) {
            if (this.logger.isInfoEnabled()) {
                if (t != null) {
                    if (params == null || params.length == 0) {
                        this.logger.info(msg, t);
                    } else {
                        this.logger.info(MessageFormat.format(msg, params), t);
                    }
                } else if (params == null || params.length == 0) {
                    this.logger.info(msg);
                } else {
                    this.logger.info(MessageFormat.format(msg, params));
                }
            }
        } else if (level.equals(Level.WARNING)) {
            if (this.logger.isWarnEnabled()) {
                if (t != null) {
                    if (params == null || params.length == 0) {
                        this.logger.warn(msg, t);
                    } else {
                        this.logger.warn(MessageFormat.format(msg, params), t);
                    }
                } else if (params == null || params.length == 0) {
                    this.logger.warn(msg);
                } else {
                    this.logger.warn(MessageFormat.format(msg, params));
                }
            }
        } else if (level.equals(Level.SEVERE) && this.logger.isErrorEnabled()) {
            if (t != null) {
                if (params == null || params.length == 0) {
                    this.logger.error(msg, t);
                } else {
                    this.logger.error(MessageFormat.format(msg, params), t);
                }
            } else if (params == null || params.length == 0) {
                this.logger.error(msg);
            } else {
                this.logger.error(MessageFormat.format(msg, params));
            }
        }
    }
}

