/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.base.client;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackConnectException;
import com.woorea.openstack.base.client.OpenStackResponse;
import com.woorea.openstack.base.client.OpenStackResponseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenStackRequest<R> {
    private OpenStackClient client;
    private String endpoint;
    private HttpMethod method;
    private StringBuilder path = new StringBuilder();
    private Map<String, List<Object>> headers = new HashMap<String, List<Object>>();
    private Entity<?> entity;
    private Class<R> returnType;
    private Map<String, List<Object>> queryParams = new LinkedHashMap<String, List<Object>>();

    public OpenStackRequest() {
    }

    public OpenStackRequest(OpenStackClient client, HttpMethod method, CharSequence path, Entity<?> entity, Class<R> returnType) {
        this.client = client;
        this.method = method;
        this.path = new StringBuilder(path);
        this.entity = entity;
        this.returnType = returnType;
        this.header("Accept", "application/json");
    }

    public OpenStackRequest<R> endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OpenStackClient getOpenStackClient() {
        return this.client;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public OpenStackRequest<R> method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpMethod method() {
        return this.method;
    }

    public OpenStackRequest<R> path(String path) {
        this.path.append(path);
        return this;
    }

    public String path() {
        return this.path.toString();
    }

    public OpenStackRequest<R> header(String name, Object value) {
        if (value != null) {
            this.headers.put(name, Arrays.asList(value));
        }
        return this;
    }

    public Map<String, List<Object>> headers() {
        return this.headers;
    }

    public <T> Entity<T> entity(T entity, String contentType) {
        return new Entity<T>(entity, contentType);
    }

    public Entity<?> entity() {
        return this.entity;
    }

    public <T> Entity<T> json(T entity) {
        return this.entity(entity, "application/json");
    }

    public void returnType(Class<R> returnType) {
        this.returnType = returnType;
    }

    public Class<R> returnType() {
        return this.returnType;
    }

    public R execute() throws OpenStackConnectException, OpenStackResponseException {
        return (R)this.client.execute(this);
    }

    public OpenStackResponse request() throws OpenStackConnectException, OpenStackResponseException {
        return this.client.request(this);
    }

    public String toString() {
        return "OpenStackRequest [endpoint=" + this.endpoint + ", method=" + (Object)((Object)this.method) + ", path=" + this.path + ", headers=" + this.headers + ", entity=" + this.entity + ", returnType=" + this.returnType + "]";
    }

    public Map<String, List<Object>> queryParams() {
        return this.queryParams;
    }

    public OpenStackRequest<R> queryParam(String key, Object value) {
        if (this.queryParams.containsKey(key)) {
            List<Object> values = this.queryParams.get(key);
            values.add(value);
        } else {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value);
            this.queryParams.put(key, values);
        }
        return this;
    }

    protected static String buildPath(String ... elements) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String element : elements) {
            stringBuilder.append(element);
        }
        return stringBuilder.toString();
    }

    public OpenStackRequest<R> queryString(String queryString) {
        if (queryString != null) {
            String[] params;
            for (String param : params = queryString.split("&")) {
                String[] s = param.split("=");
                if (s[0] == null || s[1] == null) continue;
                this.queryParam(s[0], s[1]);
            }
        }
        return this;
    }
}

