/*
 * Decompiled with CFR 0.152.
 */
package com.woorea.openstack.quantum.api;

import com.woorea.openstack.base.client.Entity;
import com.woorea.openstack.base.client.HttpMethod;
import com.woorea.openstack.base.client.OpenStackClient;
import com.woorea.openstack.base.client.OpenStackRequest;
import com.woorea.openstack.quantum.model.LoadBalancerAction;
import com.woorea.openstack.quantum.model.LoadBalancerHealthMonitor;
import com.woorea.openstack.quantum.model.LoadBalancerHealthMonitors;
import com.woorea.openstack.quantum.model.LoadBalancerMember;
import com.woorea.openstack.quantum.model.LoadBalancerMembers;
import com.woorea.openstack.quantum.model.LoadBalancerPool;
import com.woorea.openstack.quantum.model.LoadBalancerPools;
import com.woorea.openstack.quantum.model.LoadBalancerVIP;
import com.woorea.openstack.quantum.model.LoadBalancerVIPs;

public class LoadBalancerResource {
    private final OpenStackClient CLIENT;
    private final HealthMonitor healthMonitor;
    private final Member member;
    private final Pool pool;
    private final VIP vip;

    public LoadBalancerResource(OpenStackClient client) {
        this.CLIENT = client;
        this.healthMonitor = new HealthMonitor(client);
        this.member = new Member(client);
        this.pool = new Pool(client);
        this.vip = new VIP(client);
    }

    public HealthMonitor HealthMonitor() {
        return this.healthMonitor;
    }

    public Member Member() {
        return this.member;
    }

    public Pool Pool() {
        return this.pool;
    }

    public VIP VIP() {
        return this.vip;
    }

    public class VIP {
        private final OpenStackClient CLIENT;

        public VIP(OpenStackClient client) {
            this.CLIENT = client;
        }

        public List list() {
            return new List();
        }

        public Create create(LoadBalancerVIP vip) {
            return new Create(vip);
        }

        public Update update(LoadBalancerVIP vip) {
            return new Update(vip);
        }

        public Delete delete(String vipId) {
            return new Delete(vipId);
        }

        public Show show(String vipId) {
            return new Show(vipId);
        }

        public class Delete
        extends OpenStackRequest<Void> {
            public Delete(String id) {
                super(VIP.this.CLIENT, HttpMethod.DELETE, (CharSequence)Delete.buildPath((String[])new String[]{"lb/vips/", id}), null, Void.class);
            }
        }

        public class Show
        extends OpenStackRequest<LoadBalancerVIP> {
            public Show(String id) {
                super(VIP.this.CLIENT, HttpMethod.GET, (CharSequence)Show.buildPath((String[])new String[]{"lb/vips/", id}), null, LoadBalancerVIP.class);
            }
        }

        public class Update
        extends OpenStackRequest<LoadBalancerVIP> {
            public Update(LoadBalancerVIP vip) {
                super(VIP.this.CLIENT, HttpMethod.PUT, (CharSequence)Update.buildPath((String[])new String[]{"lb/vips/", vip.getId()}), Entity.json((Object)vip), LoadBalancerVIP.class);
            }
        }

        public class Create
        extends OpenStackRequest<LoadBalancerVIP> {
            public Create(LoadBalancerVIP vip) {
                super(VIP.this.CLIENT, HttpMethod.POST, (CharSequence)"lb/vips", Entity.json((Object)vip), LoadBalancerVIP.class);
            }
        }

        public class Query
        extends OpenStackRequest<LoadBalancerVIP> {
            public Query(LoadBalancerVIP vip) {
            }
        }

        public class List
        extends OpenStackRequest<LoadBalancerVIPs> {
            public List() {
                super(VIP.this.CLIENT, HttpMethod.GET, (CharSequence)"lb/vips", null, LoadBalancerVIPs.class);
            }
        }
    }

    public class Pool {
        private final OpenStackClient CLIENT;

        public Pool(OpenStackClient client) {
            this.CLIENT = client;
        }

        public List list() {
            return new List();
        }

        public Create create(LoadBalancerPool pool) {
            return new Create(pool);
        }

        public Update update(LoadBalancerPool pool) {
            return new Update(pool);
        }

        public Delete delete(String poolId) {
            return new Delete(poolId);
        }

        public Show show(String poolId) {
            return new Show(poolId);
        }

        public AssociateMonitor associateMonitor(String poolId, String healthMonitorId) {
            LoadBalancerAction.AssociateHealthMonitor hm = new LoadBalancerAction.AssociateHealthMonitor();
            hm.setId(healthMonitorId);
            return new AssociateMonitor(poolId, hm);
        }

        public DisassociateMonitor disassociateMonitor(String poolId, String healthMonitorId) {
            return new DisassociateMonitor(poolId, healthMonitorId);
        }

        public class DisassociateMonitor
        extends OpenStackRequest<Void> {
            public DisassociateMonitor(String poolId, String healthMonitorId) {
                super(Pool.this.CLIENT, HttpMethod.DELETE, (CharSequence)new StringBuilder("lb/pools/").append(poolId).append("/health_monitors/").append(healthMonitorId), null, Void.class);
            }
        }

        public class AssociateMonitor
        extends OpenStackRequest<Void> {
            public AssociateMonitor(String poolId, LoadBalancerAction.AssociateHealthMonitor healthMonitor) {
                super(Pool.this.CLIENT, HttpMethod.POST, (CharSequence)new StringBuilder("lb/pools/").append(poolId).append("/health_monitors"), Entity.json((Object)healthMonitor), Void.class);
            }
        }

        public class Delete
        extends OpenStackRequest<Void> {
            public Delete(String id) {
                super(Pool.this.CLIENT, HttpMethod.DELETE, (CharSequence)Delete.buildPath((String[])new String[]{"lb/pools/", id}), null, Void.class);
            }
        }

        public class Show
        extends OpenStackRequest<LoadBalancerPool> {
            public Show(String id) {
                super(Pool.this.CLIENT, HttpMethod.GET, (CharSequence)Show.buildPath((String[])new String[]{"lb/pools/", id}), null, LoadBalancerPool.class);
            }
        }

        public class Update
        extends OpenStackRequest<LoadBalancerPool> {
            public Update(LoadBalancerPool pool) {
                super(Pool.this.CLIENT, HttpMethod.PUT, (CharSequence)Update.buildPath((String[])new String[]{"lb/pools/", pool.getId()}), Entity.json((Object)pool), LoadBalancerPool.class);
            }
        }

        public class Create
        extends OpenStackRequest<LoadBalancerPool> {
            public Create(LoadBalancerPool pool) {
                super(Pool.this.CLIENT, HttpMethod.POST, (CharSequence)"lb/pools", Entity.json((Object)pool), LoadBalancerPool.class);
            }
        }

        public class Query
        extends OpenStackRequest<LoadBalancerPool> {
            public Query(LoadBalancerPool pool) {
            }
        }

        public class List
        extends OpenStackRequest<LoadBalancerPools> {
            public List() {
                super(Pool.this.CLIENT, HttpMethod.GET, (CharSequence)"lb/pools", null, LoadBalancerPools.class);
            }
        }
    }

    public class Member {
        private final OpenStackClient CLIENT;

        public Member(OpenStackClient client) {
            this.CLIENT = client;
        }

        public List list() {
            return new List();
        }

        public Create create(LoadBalancerMember member) {
            return new Create(member);
        }

        public Update update(LoadBalancerMember member) {
            return new Update(member);
        }

        public Delete delete(String memberId) {
            return new Delete(memberId);
        }

        public Show show(String memberId) {
            return new Show(memberId);
        }

        public class Delete
        extends OpenStackRequest<Void> {
            public Delete(String id) {
                super(Member.this.CLIENT, HttpMethod.DELETE, (CharSequence)Delete.buildPath((String[])new String[]{"lb/members/", id}), null, Void.class);
            }
        }

        public class Show
        extends OpenStackRequest<LoadBalancerMember> {
            public Show(String id) {
                super(Member.this.CLIENT, HttpMethod.GET, (CharSequence)Show.buildPath((String[])new String[]{"lb/members/", id}), null, LoadBalancerMember.class);
            }
        }

        public class Update
        extends OpenStackRequest<LoadBalancerMember> {
            public Update(LoadBalancerMember member) {
                super(Member.this.CLIENT, HttpMethod.PUT, (CharSequence)Update.buildPath((String[])new String[]{"lb/members/", member.getId()}), Entity.json((Object)member), LoadBalancerMember.class);
            }
        }

        public class Create
        extends OpenStackRequest<LoadBalancerMember> {
            public Create(LoadBalancerMember member) {
                super(Member.this.CLIENT, HttpMethod.POST, (CharSequence)"lb/members", Entity.json((Object)member), LoadBalancerMember.class);
            }
        }

        public class Query
        extends OpenStackRequest<LoadBalancerMember> {
            public Query(LoadBalancerVIP member) {
            }
        }

        public class List
        extends OpenStackRequest<LoadBalancerMembers> {
            public List() {
                super(Member.this.CLIENT, HttpMethod.GET, (CharSequence)"lb/members", null, LoadBalancerMembers.class);
            }
        }
    }

    public class HealthMonitor {
        private final OpenStackClient CLIENT;

        public HealthMonitor(OpenStackClient client) {
            this.CLIENT = client;
        }

        public List list() {
            return new List();
        }

        public Create create(LoadBalancerHealthMonitor hm) {
            return new Create(hm);
        }

        public Update update(LoadBalancerHealthMonitor hm) {
            return new Update(hm);
        }

        public Delete delete(String hmId) {
            return new Delete(hmId);
        }

        public Show show(String hmId) {
            return new Show(hmId);
        }

        public class Delete
        extends OpenStackRequest<Void> {
            public Delete(String id) {
                super(HealthMonitor.this.CLIENT, HttpMethod.DELETE, (CharSequence)Delete.buildPath((String[])new String[]{"lb/health_monitors/", id}), null, Void.class);
            }
        }

        public class Show
        extends OpenStackRequest<LoadBalancerHealthMonitor> {
            public Show(String id) {
                super(HealthMonitor.this.CLIENT, HttpMethod.GET, (CharSequence)Show.buildPath((String[])new String[]{"lb/health_monitors/", id}), null, LoadBalancerHealthMonitor.class);
            }
        }

        public class Update
        extends OpenStackRequest<LoadBalancerHealthMonitor> {
            public Update(LoadBalancerHealthMonitor hm) {
                super(HealthMonitor.this.CLIENT, HttpMethod.PUT, (CharSequence)Update.buildPath((String[])new String[]{"lb/health_monitors/", hm.getId()}), Entity.json((Object)hm), LoadBalancerHealthMonitor.class);
            }
        }

        public class Create
        extends OpenStackRequest<LoadBalancerHealthMonitor> {
            public Create(LoadBalancerHealthMonitor hm) {
                super(HealthMonitor.this.CLIENT, HttpMethod.POST, (CharSequence)"lb/health_monitors", Entity.json((Object)hm), LoadBalancerHealthMonitor.class);
            }
        }

        public class Query
        extends OpenStackRequest<LoadBalancerHealthMonitor> {
            public Query(LoadBalancerHealthMonitor hm) {
            }
        }

        public class List
        extends OpenStackRequest<LoadBalancerHealthMonitors> {
            public List() {
                super(HealthMonitor.this.CLIENT, HttpMethod.GET, (CharSequence)"lb/health_monitors", null, LoadBalancerHealthMonitors.class);
            }
        }
    }
}

