/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc;

import com.baidu.brcc.ConfigLoader;
import com.baidu.brcc.model.ChangedConfigItem;
import com.baidu.brcc.model.VersionVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangedListener
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigChangedListener.class);
    private boolean stop = true;
    private ExecutorService es;
    private Properties properties;
    private ConfigLoader configLoader;

    public boolean isStop() {
        return this.stop;
    }

    public synchronized void start() {
        if (this.es == null) {
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(@NotNull Runnable r) {
                    return new Thread(r, "ConfigChangedListener-Thread");
                }
            };
            this.es = Executors.newSingleThreadExecutor(threadFactory);
        }
        this.stop = false;
        this.es.execute(this);
    }

    public synchronized void close() {
        if (this.es != null) {
            this.stop = true;
            this.es.shutdown();
            this.es = null;
        }
    }

    public ConfigChangedListener(Properties properties, ConfigLoader configLoader) {
        this.properties = properties;
        this.configLoader = configLoader;
    }

    private ChangedConfigItem newChangedConfigItem(String key, String oldValue, String newValue) {
        ChangedConfigItem changedConfigItem = new ChangedConfigItem();
        changedConfigItem.setKey(key);
        changedConfigItem.setOldValue(oldValue);
        changedConfigItem.setNewValue(newValue);
        return changedConfigItem;
    }

    private List<ChangedConfigItem> checkChangedItems() {
        Map<String, String> configItems = null;
        try {
            configItems = this.configLoader.getFromCC();
        }
        catch (Exception ex) {
            LOGGER.warn("load from cc fail.");
            return new ArrayList<ChangedConfigItem>(0);
        }
        if (configItems == null) {
            return Collections.emptyList();
        }
        HashMap<Object, Object> copied = new HashMap<Object, Object>(this.properties);
        Iterator iterator = copied.entrySet().iterator();
        LinkedList<ChangedConfigItem> changedConfigItems = new LinkedList<ChangedConfigItem>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = entry.getKey().toString();
            String oldValue = entry.getValue().toString();
            String newValue = configItems.get(key);
            if (newValue == null) {
                changedConfigItems.add(this.newChangedConfigItem(key, oldValue, null));
                this.properties.remove(key);
            } else if (!oldValue.equals(newValue)) {
                changedConfigItems.add(this.newChangedConfigItem(key, oldValue, newValue));
                this.properties.put(key, newValue);
            }
            configItems.remove(key);
        }
        for (Map.Entry<String, String> entry : configItems.entrySet()) {
            changedConfigItems.add(this.newChangedConfigItem(entry.getKey(), null, entry.getValue()));
            this.properties.put(entry.getKey(), entry.getValue());
        }
        return changedConfigItems;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                VersionVo isLastTag;
                Thread.sleep(this.configLoader.getCallbackInteval());
                String versionTag = this.configLoader.getLastCheckSum();
                if (StringUtils.isBlank((CharSequence)versionTag)) {
                    LOGGER.warn("Found local version tag is null, it could be a error from configuration center server. ");
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking version tag to server... current tag:" + versionTag);
                }
                if (StringUtils.equals((CharSequence)((isLastTag = this.configLoader.getVersion()) == null ? "" : isLastTag.getCheckSum()), (CharSequence)versionTag)) continue;
                List<ChangedConfigItem> changedItems = this.checkChangedItems();
                this.configLoader.doCallback(changedItems);
            }
            catch (Exception e) {
                LOGGER.warn("Change verify callback failed will retry at next interval. error message:" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

