/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brcc;

import com.baidu.brcc.ConfigChangedListener;
import com.baidu.brcc.ConfigItemChangedCallable;
import com.baidu.brcc.exception.RccException;
import com.baidu.brcc.model.AuthVo;
import com.baidu.brcc.model.ChangedConfigItem;
import com.baidu.brcc.model.EnvVo;
import com.baidu.brcc.model.ItemVo;
import com.baidu.brcc.model.R;
import com.baidu.brcc.model.RList;
import com.baidu.brcc.model.VersionVo;
import com.baidu.brcc.utils.OkHttpClientUtils;
import com.baidu.brcc.utils.gson.GsonUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String AUTH_API = "/api/auth";
    private static final String ENV_API = "/api/environment/{0}";
    private static final String VERSION_API = "/api/version/{0}";
    private static final String ITEM_API = "/api/item";
    private String ccServerUrl;
    private String apiPassword;
    private String projectName;
    private String envName;
    private String ccVersionName;
    private boolean enableUpdateCallback;
    private long callbackInteval;
    private Properties rccProperties;
    private String currentToken;
    private Long envId;
    private Long versionId;
    private String lastCheckSum;
    private OkHttpClientUtils okHttpClientUtils;
    private Collection<ConfigItemChangedCallable> changedCallable;
    private ConfigChangedListener configChangedListener;

    public ConfigLoader(String ccServerUrl, String apiPassword, String projectName, String envName, String ccVersionName, boolean enableUpdateCallback, long connectionTimeOut, long readTimeOut, long callbackInteval) throws IOException {
        this.ccServerUrl = ccServerUrl;
        this.apiPassword = apiPassword;
        this.projectName = projectName;
        this.envName = envName;
        this.ccVersionName = ccVersionName;
        this.enableUpdateCallback = enableUpdateCallback;
        this.callbackInteval = callbackInteval;
        this.okHttpClientUtils = new OkHttpClientUtils(readTimeOut, connectionTimeOut);
        this.init();
    }

    private void init() throws IOException {
        this.login();
        this.getEnv();
        VersionVo version = this.getVersion();
        this.lastCheckSum = version.getCheckSum();
    }

    public String login() throws IOException {
        String authUrl = this.ccServerUrl.concat(AUTH_API);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("projectName", this.projectName);
        body.put("apiPassword", this.apiPassword);
        R<AuthVo> vo = this.okHttpClientUtils.postJson(authUrl, AuthVo.class, GsonUtils.toJsonString(body), null, null);
        if (vo == null || vo.getData() == null || vo.getStatus() != 0) {
            String msg = null;
            msg = vo == null ? "get rcc token fail." : vo.getMsg();
            throw new RccException(msg);
        }
        this.currentToken = vo.getData().getToken();
        return this.currentToken;
    }

    public Long getEnv() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.currentToken)) {
            this.login();
        }
        String envUrl = this.ccServerUrl.concat(MessageFormat.format(ENV_API, this.envName));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        R<EnvVo> result = this.okHttpClientUtils.get(envUrl, EnvVo.class, param, null);
        if (result == null || result.getData() == null || result.getStatus() != 0) {
            String msg = null;
            msg = result == null ? "get rcc env by name fail." : result.getMsg();
            throw new RccException(msg);
        }
        this.envId = result.getData().getEnvironmentId();
        return this.envId;
    }

    public VersionVo getVersion() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.currentToken)) {
            this.login();
        }
        if (this.envId == null) {
            this.getEnv();
        }
        String versionUrl = this.ccServerUrl.concat(MessageFormat.format(VERSION_API, this.ccVersionName));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        param.put("environmentId", this.envId);
        R<VersionVo> result = this.okHttpClientUtils.get(versionUrl, VersionVo.class, param, null);
        if (result == null || result.getData() == null || result.getStatus() != 0) {
            String msg = null;
            msg = result == null ? "get rcc version by name fail." : result.getMsg();
            throw new RccException(msg);
        }
        this.versionId = result.getData().getVersionId();
        return result.getData();
    }

    public Map<String, String> getFromCC() throws IOException {
        if (StringUtils.isBlank((CharSequence)this.currentToken)) {
            this.login();
        }
        String itemUrl = this.ccServerUrl.concat(ITEM_API);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("token", this.currentToken);
        param.put("versionId", this.versionId);
        RList<ItemVo> r = this.okHttpClientUtils.getList(itemUrl, ItemVo.class, param, null);
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)r.getData())) {
            Iterator iterator = r.getData().iterator();
            while (iterator.hasNext()) {
                ItemVo itemVo = (ItemVo)iterator.next();
                map.put(itemVo.getKey(), itemVo.getValue());
            }
        }
        return map;
    }

    public synchronized void startListening(Properties props) {
        if (this.configChangedListener == null) {
            this.configChangedListener = new ConfigChangedListener(props, this);
        }
        if (this.configChangedListener.isStop()) {
            this.configChangedListener.start();
        }
    }

    protected void doCallback(List<ChangedConfigItem> changedConfigItems) {
        if (CollectionUtils.isEmpty(changedConfigItems)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Empty changed config items call back.");
            }
            return;
        }
        if (this.changedCallable != null && !this.changedCallable.isEmpty()) {
            List<ChangedConfigItem> changedItems = Collections.unmodifiableList(changedConfigItems);
            for (ConfigItemChangedCallable configItemChangedCallable : this.changedCallable) {
                try {
                    configItemChangedCallable.changed(changedItems);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String getCcServerUrl() {
        return this.ccServerUrl;
    }

    public void setCcServerUrl(String ccServerUrl) {
        this.ccServerUrl = ccServerUrl;
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getCcVersionName() {
        return this.ccVersionName;
    }

    public void setCcVersionName(String ccVersionName) {
        this.ccVersionName = ccVersionName;
    }

    public boolean isEnableUpdateCallback() {
        return this.enableUpdateCallback;
    }

    public void setEnableUpdateCallback(boolean enableUpdateCallback) {
        this.enableUpdateCallback = enableUpdateCallback;
    }

    public Properties getRccProperties() {
        return this.rccProperties;
    }

    public void setRccProperties(Properties rccProperties) {
        this.rccProperties = rccProperties;
    }

    public String getCurrentToken() {
        return this.currentToken;
    }

    public String getLastCheckSum() {
        return this.lastCheckSum;
    }

    public void setLastCheckSum(String lastCheckSum) {
        this.lastCheckSum = lastCheckSum;
    }

    public void setCurrentToken(String currentToken) {
        this.currentToken = currentToken;
    }

    public long getCallbackInteval() {
        return this.callbackInteval;
    }

    public void setChangedCallable(Collection<ConfigItemChangedCallable> changedCallable) {
        this.changedCallable = changedCallable;
    }

    public void destory() {
    }
}

